﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordDerivating__Update : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.LanguageRow		current__Language
		{
			get { return this.mainForm.Current__Language; }
		}
		private BabebiDataSet.WordDerivatingRow	current__WordDerivating
		{
			get { return this.mainForm.Current__WordDerivating; }
		}

		public bool IsClosed = false;

		#region		ctors

		public Form__WordDerivating__Update(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			DerivatingWordTypeComboBoxItem currentDerivatingWordTypeComboBoxItem = null;

			List<DerivatingWordTypeComboBoxItem> derivatingWordTypeComboBoxItems
				= DerivatingWordTypeComboBoxItem.BuildDerivatingWordTypeComboBoxItems
				(
					this.current__Language
				);

			foreach (DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem in derivatingWordTypeComboBoxItems.ToList())
			{
				if (derivatingWordTypeComboBoxItem.Row.WordTypeId != this.current__WordDerivating.WordTypeId)
				{
					derivatingWordTypeComboBoxItems.Remove(derivatingWordTypeComboBoxItem);
				}
				else if(derivatingWordTypeComboBoxItem.Row.DerivatingWordTypeId == this.current__WordDerivating.DerivatingWordTypeId)
				{
					currentDerivatingWordTypeComboBoxItem = derivatingWordTypeComboBoxItem;
				}
			}

			if (derivatingWordTypeComboBoxItems.Count != 1)
			{
				this.comboBox__DerivatingWordType.Items.AddRange(derivatingWordTypeComboBoxItems.ToArray());

				this.comboBox__DerivatingWordType.SelectedItem = currentDerivatingWordTypeComboBoxItem;
			}
			else
			{
				DerivatingWordTypeComboBoxItem theDerivatingWordTypeComboBoxItem = derivatingWordTypeComboBoxItems[0];

				this.comboBox__DerivatingWordType.Items.Add(theDerivatingWordTypeComboBoxItem);

				this.comboBox__DerivatingWordType.SelectedItem = theDerivatingWordTypeComboBoxItem;

			//	this.button__Update__Click(null, null);

				this.IsClosed = true;
			}
		}

		public Form__WordDerivating__Update()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Update__Click(object sender, EventArgs e)
		{
			DerivatingWordTypeComboBoxItem selectedDerivatingWordTypeComboBoxItem		
				= (DerivatingWordTypeComboBoxItem)this.comboBox__DerivatingWordType.SelectedItem;

			BabebiDataSet.DerivatingWordTypeRow selectedDerivatingWordType
				= 
				(
					(BabebiDataSet.DerivatingWordType_LanguageRow)
					(selectedDerivatingWordTypeComboBoxItem.Row)
				)
				.DerivatingWordTypeRowParent;

			if
			(
				selectedDerivatingWordType
				==
				this.mainForm.Current__DerivatingWordType_Language__of__WordDerivating.DerivatingWordTypeRowParent
			)
			{
				MessageBox.Show
				(
					"The selected 'Derivating Word Type' is the same one than the current one.", 
					"No updating",
					MessageBoxButtons.OK,
					MessageBoxIcon.Information
				);

				return;
			}

			this.mainForm.Current__WordDerivating.DerivatingWordTypeRowParent = selectedDerivatingWordType;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
