﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordType__Create : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.WordTypeDataTable				table__WordType;
		private BabebiDataSet.WordType_LanguageDataTable	table__WordType_Language;

		private short	derivatingWordTypeId = Int16.MinValue;

		private BabebiDataSet.LanguageRow current__Language
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}

		#region		ctors

		public Form__WordType__Create(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__WordType			= this.mainForm.DataSet.WordType;
			this.table__WordType_Language	= this.mainForm.DataSet.WordType_Language;

			#region	WordTypeId

			short? biggestId = null;
			foreach (var WordType in this.table__WordType)
			{
				if (!biggestId.HasValue || WordType.Id > biggestId.Value)
				{
					biggestId = WordType.Id;
				}
			}
			this.textBox__WordTypeId.Text = (biggestId + 1).ToString();

			#endregion	WordTypeId

			this.textBox__WordTypeName.Text = "...";
		}

		public Form__WordType__Create()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Create__Click(object sender, EventArgs e)
		{
			if (this.derivatingWordTypeId == Int16.MinValue)
			{
				MessageBox.Show("A value of 'Id' is required.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			string derivatingWordTypeName	= this.textBox__WordTypeName.Text;
			if ( ! MainForm.UserEntryChecking(this.table__WordType			.NameColumn	, derivatingWordTypeName	)) { return; }

			string name						= this.textBox__Name.Text;
			if ( ! MainForm.UserEntryChecking(this.table__WordType_Language.NameColumn	, name						)) { return; }

			if (derivatingWordTypeName == "...")
			{
				derivatingWordTypeName = "**" + this.current__Language.Code + "**" + name;
			}

			this.mainForm.Current__WordType
				= this.table__WordType.AddWordTypeRow
				(
					this.derivatingWordTypeId, 
					derivatingWordTypeName
				);

			#region		build WordType_Language dataRows
			
			foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
			{
				if (language == this.mainForm.Current__Language)
				{
					this.mainForm.Current__WordType_Language
						= this.mainForm.DataSet.WordType_Language
						.AddWordType_LanguageRow
						(
							this.mainForm.Current__WordType,
							language,
							name
						);
				}
				else
				{
					this.mainForm.DataSet.WordType_Language
						.AddWordType_LanguageRow
						(
							this.mainForm.Current__WordType,
							language,
							"**" + this.current__Language.Code + "**" + name
						);
				}
			}
			
			#endregion	build WordType_Language dataRows

			this.DialogResult = DialogResult.OK;

			this.Close();
		}


		private void textBox__WordTypeId__Validating(object sender, CancelEventArgs e)
		{
			string s = this.textBox__WordTypeId.Text;

			if (string.IsNullOrEmpty(s))
			{
				this.derivatingWordTypeId = Int16.MinValue;
				e.Cancel = false;
			}
			else if( ! short.TryParse(s, out this.derivatingWordTypeId) )
			{
				MessageBox.Show("The value of the 'Id' must be an integer value.", "Interger required", MessageBoxButtons.OK, MessageBoxIcon.Error);

				this.derivatingWordTypeId = Int16.MinValue;

				e.Cancel = true;
			}
			else
			{
				e.Cancel = false;
			}
		}
	}
}
