﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordType__Update : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.WordTypeDataTable				table__WordType;
		private BabebiDataSet.WordType_LanguageDataTable	table__WordType_Language;

		private short	derivatingWordTypeId = Int16.MinValue;

		private BabebiDataSet.LanguageRow current__Language
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}

		private BabebiDataSet.WordTypeRow current__WordType
		{
			get
			{
				return this.mainForm.Current__WordType;
			}
		}
		private BabebiDataSet.WordType_LanguageRow current__WordType_Language
		{
			get
			{
				return this.mainForm.Current__WordType_Language;
			}
		}

		#region		ctors

		public Form__WordType__Update(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__WordType			= this.mainForm.DataSet.WordType;
			this.table__WordType_Language	= this.mainForm.DataSet.WordType_Language;

			this.textBox__WordTypeId.Text	= this.current__WordType			.Id		.ToString()	;
			this.textBox__WordTypeName.Text = this.current__WordType			.Name				;
			this.textBox__Name.Text			= this.current__WordType_Language	.Name				;
		}

		public Form__WordType__Update()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Create__Click(object sender, EventArgs e)
		{
			if (this.derivatingWordTypeId == Int16.MinValue)
			{
				MessageBox.Show("A value of 'Id' is required.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			string wordTypeName	= this.textBox__WordTypeName.Text;
			if ( ! MainForm.UserEntryChecking(this.table__WordType.NameColumn, wordTypeName)) { return; }

			string name						= this.textBox__Name.Text;
			if ( ! MainForm.UserEntryChecking(this.table__WordType_Language.NameColumn, name)) { return; }

			this.current__WordType.Id	= this.derivatingWordTypeId;
			this.current__WordType.Name	= wordTypeName;

			#region		update WordType_Language dataRows
			
			string name__old = this.current__WordType_Language.Name;

			if (name__old != name)
			{
				foreach (BabebiDataSet.WordType_LanguageRow wordType_language in this.current__WordType.GetWordType_LanguageRows())
				{
					if (wordType_language == this.current__WordType_Language)
					{
						this.current__WordType_Language.Name = name;
					}
					else
					{
						if (wordType_language.Name == "**" + this.current__Language.Code + "**" + name__old)
						{
							wordType_language.Name = "**" + this.current__Language.Code + "**" + name;
						}
					}
				}
			}

			#endregion	update WordType_Language dataRows

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private void textBox__WordTypeId__Validating(object sender, CancelEventArgs e)
		{
			string s = this.textBox__WordTypeId.Text;

			if (string.IsNullOrEmpty(s))
			{
				this.derivatingWordTypeId = Int16.MinValue;
				e.Cancel = false;
			}
			else if( ! short.TryParse(s, out this.derivatingWordTypeId) )
			{
				MessageBox.Show("The value of the 'Id' must be an integer value.", "Interger required", MessageBoxButtons.OK, MessageBoxIcon.Error);

				this.derivatingWordTypeId = Int16.MinValue;

				e.Cancel = true;
			}
			else
			{
				e.Cancel = false;
			}
		}

		private void textBox__Name_TextChanged(object sender, EventArgs e)
		{
			if (this.textBox__WordTypeName.Text == "**" + this.current__Language.Code + "**" + this.current__WordType_Language.Name)
			{
				this.textBox__WordTypeName.Text = "**" + this.current__Language.Code + "**" + this.textBox__Name.Text;
			}
		}
	}
}
