﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Word_LanguageWord__Create : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.Word_LanguageWordDataTable table__Word_LanguageWord;

		#region		ctors

		public Form__Word_LanguageWord__Create(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;
			this.table__Word_LanguageWord = this.mainForm.DataSet.Word_LanguageWord;

			this.textBox__Word__Id					.Text = this.mainForm.Current__Word.Id.ToString();
			this.textBox__Word__String				.Text = this.mainForm.Current__Word.UniqueKeyString;
			this.textBox__Word_Language__Meaning	.Text = this.mainForm.Current__Word_Language.Meaning;
			this.textBox__LanguageWord__String		.Text = this.mainForm.Current__LanguageWord.String;
		}

		public Form__Word_LanguageWord__Create()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Create__Click(object sender, EventArgs e)
		{
			#region		build Word_LanguageWord dataRows

			string currentLanguageCode = this.mainForm.Current__Language.Code;

			foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
			{
				string insertedLanguageWordString
					= 
					(
						language == this.mainForm.Current__Language 
						? 
						this.mainForm.Current__LanguageWord.String : 
						"**" + currentLanguageCode + "**" + this.mainForm.Current__LanguageWord.String
					);

				/*
				BabebiDataSet.Word_LanguageWordRow w_lw
					= this.table__Word_LanguageWord
					.FindByWordIdLanguageCodeLanguageWordString
					(
						this.mainForm.Current__Word.Id,
						language.Code,
						insertedLanguageWordString
					);

				if (w_lw.RowState == DataRowState.Detached)
				{
				}
				*/

				string languageWordString 
					=
					(
						language == this.mainForm.Current__Language 
						? 
						this.mainForm.Current__LanguageWord.String : 
						"**" + currentLanguageCode + "**" + this.mainForm.Current__LanguageWord.String
					);

				BabebiDataSet.LanguageWordRow parentLanguageWord
					= this.mainForm.DataSet.LanguageWord
					.FindByLanguageCodeString
					(
						language.Code,
						languageWordString
					);
				if (parentLanguageWord == null)
				{ 
					parentLanguageWord
						= this.mainForm.DataSet.LanguageWord
						.AddLanguageWordRow
						(
							language,
							languageWordString
						);
				}

				BabebiDataSet.Word_LanguageWordRow newWord_LanguageWordRow
					= this.table__Word_LanguageWord
					.AddWord_LanguageWordRow
					(
						this.mainForm.Current__Word.Id,
						language.Code,
						languageWordString
					);

				if (language == this.mainForm.Current__Language)
				{
					this.mainForm.Current__Word_LanguageWord__of__Word			= newWord_LanguageWordRow;
					this.mainForm.Current__Word_LanguageWord__of__LanguageWord	= newWord_LanguageWordRow;
				}
			}

			#endregion	build Word_LanguageWord dataRows

			this.Close();
		}
	}
}
