﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Word__CreateUpdate : Form
	{
		private MainForm mainForm;
		private bool trueForCreate__falseForUpdate;

		#region		variables

		private int word__Id = -1;

		private BabebiDataSet.WordType_LanguageRow selected__WordType_Language = null;

		private BabebiDataSet.LanguageRow	currentLanguage		
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode	
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		#endregion	variables
		#region		error management

		private TextBox_WEM		textBox_WEM__Id					;
		private TextBox_WEM		textBox_WEM__UniqueKeyString	;
		private TextBox_WEM		textBox_WEM__Meaning			;
		private ComboBox_WEM	comboBox_WEM__WordType			;

		#endregion	error variables
		#region		ctors

		public Form__Word__CreateUpdate(MainForm mainForm, bool trueForCreate__falseForUpdate) : this()
		{
			this.mainForm = mainForm;
			this.trueForCreate__falseForUpdate = trueForCreate__falseForUpdate;

			this.mainForm.Ctor__CreateUpdate__Word
			(
				this,
				this.button__CreateUpdate,
				this.button__Clone,
				MainForm.ModeName_NotDefined,
				this.label__Word__Id,
				this.label__Word__UniqueKeyString,
				this.label__Word_Language__Meaning,
				this.label__WordType_LanguageName,
				this.textBox__Word__Id,
				this.textBox__Word__UniqueKeyString,
				this.textBox__Word_Language__Meaning,
				this.comboBox__WordType_LanguageName,
				false,
			out TextBox_WEM		textBox_WEM__Word__Id_				,
			out TextBox_WEM		textBox_WEM__Word__UniqueKeyString_	,
			out TextBox_WEM		textBox_WEM__Word_Language__Meaning_,
			out ComboBox_WEM	comboBox_WEM__WordType_LanguageName_,
				this.trueForCreate__falseForUpdate,
			ref this.word__Id,
			ref this.selected__WordType_Language,
				this.mainForm.Current__Word,					
				this.mainForm.Current__Word_Language
			);
			this.textBox_WEM__Id				= textBox_WEM__Word__Id_				;
			this.textBox_WEM__UniqueKeyString	= textBox_WEM__Word__UniqueKeyString_	;
			this.textBox_WEM__Meaning			= textBox_WEM__Word_Language__Meaning_	;
			this.comboBox_WEM__WordType			= comboBox_WEM__WordType_LanguageName_	;
		}

		public Form__Word__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors
		#region		events

		private void button__Clone__Click(object sender, EventArgs e)
		{
			this.mainForm.Clone__Word
			(
				this.textBox__Word__UniqueKeyString,
				this.textBox__Word_Language__Meaning,
				this.comboBox__WordType_LanguageName,
				false,
				this.mainForm.Current__Word,					
				this.mainForm.Current__Word_Language
			);
		}

		#region		Word__Id

		private void textBox__Word__Id__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Integer__KeyPress(e);
		}
		private void textBox__Word__Id__TextChanged(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Id == null)
			{ 
				return; /// cela arrive lorsque l'on sette l'Id par le ctor mutualisé et que l'on n'en est pas encore sorti pour setter les outs.
			}

			this.mainForm.Word__Id__TextChanged(this.textBox_WEM__Id, ref this.word__Id);
		}
		private void textBox__Word__Id__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Id.HasError && !string.IsNullOrEmpty(this.textBox__Word__Id.Text))
			{
				this.textBox_WEM__Id.ShowMessageBox();
			}
		}

		#endregion	Word__Id
		#region		Word__String

		private void textBox__Word__String__TextChanged(object sender, EventArgs e)
		{		
			this.mainForm.Word__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);
		}
		private void textBox__Word__String__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__UniqueKeyString.HasError && !string.IsNullOrEmpty(this.textBox__Word__UniqueKeyString.Text))
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();
			}
		}

		#endregion	Word__String
		#region		Word__Meaning

		private void textBox__Word_Language__Meaning__TextChanged(object sender, EventArgs e)
		{
			this.mainForm.Word__Meaning__TextChanged(this.textBox_WEM__Meaning);
		}

		private void textBox__Word_Language__Meaning__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Meaning.HasError && !string.IsNullOrEmpty(this.textBox__Word_Language__Meaning.Text))
			{
				this.textBox_WEM__Meaning.ShowMessageBox();
			}
		}

		#endregion	Word__Meaning
		#region		WordType

		private void comboBox__WordType_LanguageName_SelectedIndexChanged(object sender, EventArgs e)
		{
			this.mainForm.Word__WordType__SelectedIndexChanged(this.comboBox_WEM__WordType, ref this.selected__WordType_Language);
		}

		#endregion	WordType

		#endregion	events

		private void button__Create__Click(object sender, EventArgs e)
		{
			#region		checking

			if (this.textBox_WEM__Id.HasError)
			{
				this.textBox_WEM__Id.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__Meaning.HasError)
			{
				this.textBox_WEM__Meaning.ShowMessageBox();

				return;
			}
			if (this.comboBox_WEM__WordType.HasError)
			{
				this.comboBox_WEM__WordType.ShowMessageBox();

				return;
			}

			#endregion	checking

			if (this.trueForCreate__falseForUpdate)
			{
				this.mainForm.Create__Word
				(
					this.word__Id,
					this.textBox__Word__UniqueKeyString.Text,
					this.textBox__Word_Language__Meaning.Text,
					this.selected__WordType_Language.WordTypeRow,
				out BabebiDataSet.WordOrPatternRow current__WordOrPattern__of__Word,
				out BabebiDataSet.WordRow current__Word,
				out BabebiDataSet.Word_LanguageRow current__Word_Language,
				out BabebiDataSet.LanguageWordRow current__LanguageWord
				);

				this.mainForm.Current__WordOrPattern__of__Word = current__WordOrPattern__of__Word;
				this.mainForm.Current__Word = current__Word;
				this.mainForm.Current__Word_Language = current__Word_Language;
				this.mainForm.Current__LanguageWord = current__LanguageWord;
			}
			else
			{
				if
				(
					this.mainForm.Current__Word.ModeCode == MainForm.ModeCode_FromPattern
					&&
					this.word__Id != this.mainForm.Current__Word.Id
				)
				{ 
					MessageBox.Show
					(
						"The 'Word Id' will not be updated as requested because this Word is a 'Word (From Pattern)' " +
						"and such a Word cannot have their Id updated.",
						"Id will not be updated",
						MessageBoxButtons.OK,
						MessageBoxIcon.Warning
					);

					this.word__Id = this.mainForm.Current__Word.Id;	/// reset the Id.
				}

				this.mainForm.Update__Word
				(
					this.word__Id,
					this.textBox__Word__UniqueKeyString.Text,
					this.textBox__Word_Language__Meaning.Text,
					this.selected__WordType_Language.WordTypeRow,
					this.mainForm.Current__WordOrPattern__of__Word,
					this.mainForm.Current__Word,
					this.mainForm.Current__Word_Language,
				out BabebiDataSet.LanguageWordRow current__LanguageWord	/// renvoie null si toujours le même.
				);

				if (current__LanguageWord != null)
				{
					this.mainForm.Current__LanguageWord = current__LanguageWord;
				}
			}

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private void button__ClearUniqueKeyStringError__Click(object sender, EventArgs e)
		{
			if (this.textBox_WEM__UniqueKeyString.HasError && this.textBox_WEM__UniqueKeyString.Header == "Invalid character")
			{ 
				this.textBox_WEM__UniqueKeyString.ClearError();
			}
		}
	}
}
