﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Word__Find : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.WordDataTable					table__Word;
		private BabebiDataSet.Word_LanguageDataTable		table__Word_Language;

		private DataSet			guiDataSet;

		private DataTable		guiTable__Word;
		private DataColumn		guiColumn__Word__Id;
		private DataColumn		guiColumn__Word__String;
		private DataColumn		guiColumn__Word__Meaning;
		private BindingSource	bindingSource__Word;

		private BabebiDataSet.WordRow			selected__Word			= null;
		private BabebiDataSet.Word_LanguageRow	selected__Word_Language = null;

		#region		ctors

		public Form__Word__Find(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__Word				= this.mainForm.DataSet.Word;
			this.table__Word_Language		= this.mainForm.DataSet.Word_Language;

			this.guiDataSet = new DataSet("GuiDataSet");

			#region		guiTable__Word

			this.guiTable__Word = this.guiDataSet.Tables.Add("Word");

			this.guiColumn__Word__Id		= this.guiTable__Word.Columns.Add("Id"		, typeof(int));
			this.guiColumn__Word__String	= this.guiTable__Word.Columns.Add("String"	, typeof(string));
			this.guiColumn__Word__Meaning	= this.guiTable__Word.Columns.Add("Meaning"	, typeof(string));

			this.guiTable__Word.PrimaryKey = new DataColumn[] { this.guiColumn__Word__Id };

			this.bindingSource__Word = new BindingSource(this.guiDataSet, this.guiTable__Word.TableName);

			this.dataGridView__Word.DataSource = this.bindingSource__Word;

			this.bindingSource__Word.CurrentChanged += bindingSource__Word_CurrentChanged;

			#endregion	guiTable__Word

			this.button__OK.Enabled = false;
		}

		public Form__Word__Find()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__OK__Click(object sender, EventArgs e)
		{
			if (this.selected__Word == null)
			{
				MessageBox.Show("A Word must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			this.mainForm.Current__Word						= this.selected__Word;
			this.mainForm.Current__WordOrPattern__of__Word	= this.mainForm.Current__Word.WordOrPatternRowParent;
			this.mainForm.Current__Word_Language			= this.selected__Word_Language;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private void populate()
		{
			if (this.selected__Word != null)
			{
				this.textBox__FoundWordString	.Text = this.selected__Word.UniqueKeyString;
				this.textBox__FoundWordMeaning	.Text = this.selected__Word_Language.Meaning;

				this.button__OK.Enabled = true;
			}
			else
			{ 
				this.textBox__FoundWordString	.Text = null;
				this.textBox__FoundWordMeaning	.Text = null;

				this.button__OK.Enabled = false;
			}
		}

		private void textBox__Word__UniqueKeyString__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting = this.mainForm.textBox__Word__UniqueKeyString__TextChanged
			(
				textBox__Word__String,
				textBox__Word_Language__Meaning,
				guiTable__Word,
				null,
			out BabebiDataSet.WordRow			selected__Word_, 
			out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
			);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				this.button__OK.Enabled = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Word				= selected__Word_;
			this.selected__Word_Language	= selected__Word_Language_;

			this.populate();

			#region		(ancienne version)
			/*
			if (this.doNotSearch)
			{
				return;
			}

			string wordString = this.textBox__Word__String.Text;

			this.guiTable__Word.Clear();

			if (string.IsNullOrEmpty(wordString))
			{
				///
				this.preventCharEntry = false;
				
				this.selected__Word = null;
				this.selected__Word_Language = null;

				this.doNotSearch = true;
				this.textBox__Word_Language__Meaning.Text = null;
				this.doNotSearch = false;

				if (this.button__OK.Enabled)
				{
					this.button__OK.Enabled = false;
				}
			}
			else if (wordString.Length == 1)
			{
				DataRow[] selectedWords = this.table__Word.Select("UniqueKeyString = '" + wordString + "'");

				if (selectedWords.Length == 1)
				{
					///
					this.preventCharEntry = true;

					this.selected__Word = (BabebiDataSet.WordRow)(selectedWords[0]);
					this.selected__Word_Language
						= this.table__Word_Language
						.FindByWordIdLanguageCode
						(
							this.selected__Word.Id,
							this.mainForm.Current__Language.Code
						);

					this.doNotSearch = true;
					this.textBox__Word_Language__Meaning.Text = this.selected__Word_Language.Meaning;
					this.doNotSearch = false;

					if (!this.button__OK.Enabled)
					{
						this.button__OK.Enabled = true;
					}
				}
				else
				{
					///
					this.preventCharEntry = false;

					this.selected__Word = null;
					this.selected__Word_Language = null;

					this.doNotSearch = true;
					this.textBox__Word_Language__Meaning.Text = null;
					this.doNotSearch = false;

					if (this.button__OK.Enabled)
					{
						this.button__OK.Enabled = false;
					}
				}
			}
			else
			{
				DataRow[] selectedWords = this.table__Word.Select("UniqueKeyString LIKE '*" + wordString + "*'");

				if (selectedWords.Length == 0)
				{
					///
					this.preventCharEntry = false;

					this.selected__Word = null;
					this.selected__Word_Language = null;

					this.doNotSearch = true;
					this.textBox__Word_Language__Meaning.Text = null;
					this.doNotSearch = false;

					this.button__OK.Enabled = false;
				}
				else if (selectedWords.Length == 1)
				{
					///
					this.preventCharEntry = true;

					this.selected__Word				= (BabebiDataSet.WordRow)(selectedWords[0]);
					this.selected__Word_Language	
						= this.table__Word_Language
						.FindByWordIdLanguageCode
						(
							this.selected__Word.Id,
							this.mainForm.Current__Language.Code
						);

					this.doNotSearch = true;
					this.textBox__Word_Language__Meaning.Text = this.selected__Word_Language.Meaning;
					this.doNotSearch = false;

					if (!this.button__OK.Enabled)
					{
						this.button__OK.Enabled = true;
					}
				}
				else
				{
					///
					this.preventCharEntry = false;

					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.WordRow selectedWord in selectedWords)
					{
						BabebiDataSet.Word_LanguageRow selectedWord_Language
							= this.table__Word_Language
							.FindByWordIdLanguageCode
							(
								selectedWord.Id,
								this.mainForm.Current__Language.Code
							);

						DataRow guiDataRow 
							= this.guiTable__Word
							.Rows
							.Add
							(
								selectedWord.Id,
								selectedWord.UniqueKeyString,
								selectedWord_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedWord.UniqueKeyString == wordString)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateWord(matchingGuiDataRow);
						
						///
						this.preventCharEntry = true;
					}

					if (!this.button__OK.Enabled)
					{
						this.button__OK.Enabled = true;
					}
				}
			}
			*/
			#endregion	(ancienne version)
		}
		private void textBox__Word_Language__Meaning__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting
				= this.mainForm.textBox__Word__Meaning__TextChanged
				(
					this.textBox__Word__String,
					this.textBox__Word_Language__Meaning,
					this.guiTable__Word,
				out BabebiDataSet.WordRow			selected__Word_, 
				out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
				);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Word				= selected__Word_;
			this.selected__Word_Language	= selected__Word_Language_;

			this.populate();

			#region		(ancienne version)
			/*
			if (this.doNotSearch)
			{
				return;
			}

			string word_language__meaning = this.textBox__Word_Language__Meaning.Text;

			this.guiTable__Word.Clear();

			if (word_language__meaning.Length < 2)
			{
				this.selected__Word				= null;
				this.selected__Word_Language	= null;

				this.doNotSearch = true;
				this.textBox__Word__String.Text = null;
				this.doNotSearch = false;

				return;
			}
			else
			{
				DataRow[] selectedWord_Languages 
					= this.table__Word_Language
					.Select
					(
						"LanguageCode = '" +
						this.mainForm.Current__Language.Code +
						"' AND Meaning LIKE '*" + word_language__meaning + "*'"
					);

				if (selectedWord_Languages.Length == 1)
				{
					this.selected__Word_Language	= (BabebiDataSet.Word_LanguageRow)(selectedWord_Languages[0]);
					this.selected__Word				=  this.selected__Word_Language.WordRowParent;

					this.doNotSearch = true;
					this.textBox__Word__String.Text = this.selected__Word.UniqueKeyString;
					this.doNotSearch = false;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.Word_LanguageRow selectedWord_Language in selectedWord_Languages)
					{
						BabebiDataSet.WordRow selectedWord = selectedWord_Language.WordRowParent;

						DataRow guiDataRow 
							= this.guiTable__Word
							.Rows
							.Add
							(
								selectedWord_Language	.WordId,
								selectedWord			.UniqueKeyString,
								selectedWord_Language	.Meaning
							);

						if (matchingGuiDataRow == null && selectedWord_Language.Meaning == word_language__meaning)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateWord(matchingGuiDataRow);
					}
				}
			}
			*/
			#endregion	(ancienne version)
		}

		private void bindingSource__Word_CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView__Word.Focused)
			{
				this.populateWord(((DataRowView)(this.bindingSource__Word.Current)).Row);
			}
		}

		private void populateWord(DataRow guiWordDataRow)
		{
			if (this.dataGridView__Word.Focused)
			{
				DataRow guiDataRow__Pattern = ((DataRowView)(this.bindingSource__Word.Current)).Row; 
				
				int		selectedId = (int)(guiDataRow__Pattern["Id"]);

				this.selected__Word
					= this.table__Word
					.FindById(selectedId);
			
				this.selected__Word_Language
					= this.table__Word_Language
					.FindByWordIdLanguageCode(selectedId, this.mainForm.Current__Language.Code);

				this.populate();
			}

			#region		(ancienne version)
			/*


			this.doNotSearch = true;

			this.selected__Word 
				= this.table__Word
				.FindById
				(
					(int)(guiWordDataRow["Id"])
				);

			this.selected__Word_Language
				= this.table__Word_Language
				.FindByWordIdLanguageCode
				(
					(int)(guiWordDataRow["Id"]),
					this.mainForm.Current__Language.Code
				);

			this.textBox__Word__String			.Text = this.selected__Word			.UniqueKeyString	;
			this.textBox__Word_Language__Meaning.Text = this.selected__Word_Language.Meaning;

			this.doNotSearch = false;
			*/

			#endregion	(ancienne version)
		}

		bool preventCharEntry = false;
		private void textBox__Word__UniqueKeyString_KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Searching__UniqueKeyString__KeyPress(this.preventCharEntry, e);

			#region		(ancienne version)
			/*
			char c = e.KeyChar;

			/// back : toujours.
			if (c == '\b')	
			{
				e.Handled = false;
			}
			else
			{
				if (this.preventCharEntry)
				{
					e.Handled = true;
				}
				else
				{
					e.Handled = false;
				}
			}
			*/
			#endregion	(ancienne version)
		}
	}
}
