﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Word__FindById : Form
	{
		private MainForm mainForm;

		#region		ctors

		public Form__Word__FindById(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;
		}

		public Form__Word__FindById()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void textBox__Word__Id__KeyPress(object sender, KeyPressEventArgs e)
		{
			char c = e.KeyChar;

			/// les chiffres + back + coller.
			if (char.IsNumber(c) || c == '\b' || c == '\u0016')	
			{
				e.Handled = false;
			}
			else
			{ 
				e.Handled = true;
			}

		}

		private void button__OK__Click(object sender, EventArgs e)
		{
			string wordIdString = this.textBox__Word__Id.Text;

			if (string.IsNullOrEmpty(wordIdString))
			{
				MessageBox.Show("There is no Word Id.","Missing Id", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			int wordId = int.Parse(wordIdString);

			BabebiDataSet.WordRow word = this.mainForm.DataSet.Word.FindById(wordId);

			if (word == null)
			{
				MessageBox.Show("'" + wordIdString + "' is not the Id of an existing Word.","Not existing Id", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			this.mainForm.Current__Word = word;

			this.mainForm.Current__Word_Language	
				= this.mainForm.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(	
					wordId, 
					this.mainForm.Current__Language.Code
				);

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
