﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	internal partial class Form__SentenceWord : Form
	{
		private MainForm mainForm;

		#region		shortCuts

		private string						current__Language__Code
		{
			get { return this.mainForm.Current__Language.Code; }
		}
		private BabebiDataSet.LanguageRow	current__Language
		{
			get { return this.mainForm.Current__Language; }
		}

		#endregion	shortCuts
		#region		the Gui DataTable

		private DataSet			guiDataSet;

		private DataTable		guiTable__Word;
		private DataColumn		guiColumn__Word__Id;
		private DataColumn		guiColumn__Word__String;
		private DataColumn		guiColumn__Word__Meaning;
		private BindingSource	bindingSource__Word;

		#endregion	the Gui DataTable
		#region		variables

		private BabebiDataSet.WordRow			selected__Word			= null;
		private BabebiDataSet.Word_LanguageRow	selected__Word_Language = null;

		#endregion	variables

		#region		ctors

		internal Form__SentenceWord(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			#region		guiTable__Word

			this.guiDataSet = new DataSet("GuiDataSet");

			this.guiTable__Word = this.guiDataSet.Tables.Add("Word");

			this.guiColumn__Word__Id		= this.guiTable__Word.Columns.Add("Id"		, typeof(int));
			this.guiColumn__Word__String	= this.guiTable__Word.Columns.Add("String"	, typeof(string));
			this.guiColumn__Word__Meaning	= this.guiTable__Word.Columns.Add("Meaning"	, typeof(string));

			this.guiTable__Word.PrimaryKey = new DataColumn[] { this.guiColumn__Word__Id };

			this.bindingSource__Word = new BindingSource(this.guiDataSet, this.guiTable__Word.TableName);

			this.dataGridView__Word.DataSource = this.bindingSource__Word;

			this.bindingSource__Word.CurrentChanged += bindingSource__Word_CurrentChanged;

			#endregion	guiTable__Word

			this.button__OK.Enabled = false;

			if (this.mainForm.Current__Sentence_LanguageLanguageWord != null)
			{
				this.textBox__Word_Language__Meaning.Text = this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString;
			}
		}

		private Form__SentenceWord()
		{
			InitializeComponent();
		}

		#endregion	ctors

		#region		about Word selecting

		private void populate()
		{
			if (this.selected__Word != null)
			{
				this.textBox__FoundWordString	.Text = this.selected__Word.UniqueKeyString;
				this.textBox__FoundWordMeaning	.Text = this.selected__Word_Language.Meaning;

				this.button__OK.Enabled = true;
			}
			else
			{ 
				this.textBox__FoundWordString	.Text = null;
				this.textBox__FoundWordMeaning	.Text = null;

				this.button__OK.Enabled = false;
			}
		}

		private void textBox__Word__UniqueKeyString__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting = this.mainForm.textBox__Word__UniqueKeyString__TextChanged
			(
				textBox__Word__String,
				textBox__Word_Language__Meaning,
				guiTable__Word,
				null,
			out BabebiDataSet.WordRow			selected__Word_, 
			out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
			);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				this.button__OK.Enabled = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Word				= selected__Word_;
			this.selected__Word_Language	= selected__Word_Language_;

			this.populate();
		}
		private void textBox__Word_Language__Meaning__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting
				= this.mainForm.textBox__Word__Meaning__TextChanged
				(
					this.textBox__Word__String,
					this.textBox__Word_Language__Meaning,
					this.guiTable__Word,
				out BabebiDataSet.WordRow			selected__Word_, 
				out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
				);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Word				= selected__Word_;
			this.selected__Word_Language	= selected__Word_Language_;

			this.populate();
		}

		private void bindingSource__Word_CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView__Word.Focused)
			{
				this.populateWord(((DataRowView)(this.bindingSource__Word.Current)).Row);
			}
		}

		private void populateWord(DataRow guiWordDataRow)
		{
			if (this.dataGridView__Word.Focused)
			{
				DataRow guiDataRow__Pattern = ((DataRowView)(this.bindingSource__Word.Current)).Row; 
				
				int		selectedId = (int)(guiDataRow__Pattern["Id"]);

				this.selected__Word
					= this.mainForm.DataSet.Word
					.FindById(selectedId);
			
				this.selected__Word_Language
					= this.mainForm.DataSet.Word_Language
					.FindByWordIdLanguageCode(selectedId, this.mainForm.Current__Language.Code);

				this.populate();
			}
		}

		bool preventCharEntry = false;
		private void textBox__Word__UniqueKeyString_KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Searching__UniqueKeyString__KeyPress(this.preventCharEntry, e);
		}

		#endregion	about Word selecting
		#region		about WordExNihilo (Name)

		private void button__Retrieve__Click(object sender, EventArgs e)
		{
			if (this.mainForm.Current__Sentence_LanguageLanguageWord != null)
			{
				this.textBox__WordExNihilo__String.Text 
					= this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString;

				this.button__OK.Enabled = true;
			}
		}

		private void textBox__WordExNihilo__String__TextChanged(object sender, EventArgs e)
		{
			string newName = this.textBox__WordExNihilo__String.Text;

			if (newName.Length == 0)
			{
				if (string.IsNullOrEmpty(this.textBox__FoundWordString.Text))
				{
					this.button__OK.Enabled = false;
				}
				else
				{ 
					this.button__OK.Enabled = true;
				}
			}
			else
			{
				this.button__OK.Enabled = true;
			}
		}

		#endregion	about WordExNihilo (Name)

		private void button__OK__Click(object sender, EventArgs e)
		{
			string newName = this.textBox__WordExNihilo__String.Text;

			if (this.selected__Word == null && string.IsNullOrEmpty(newName))
			{
				MessageBox.Show("A Word must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			BabebiDataSet.Word_LanguageWordRow word_LanguageWord = null;

			if (this.selected__Word == null)
			{
				BabebiDataSet.WordRow[] wordRows 
					= 
					(BabebiDataSet.WordRow[])
					(this.mainForm.DataSet.Word.Select("UniqueKeyString = '" + newName + "'"));

				if (wordRows.Length == 1)
				{
					this.selected__Word = wordRows[0];

					this.selected__Word_Language 
						= this.mainForm.DataSet
						.Word_Language
						.FindByWordIdLanguageCode
						(
							this.selected__Word.Id,
							this.current__Language__Code
						);
				}
				else if (this.mainForm.Current__Sentence_LanguageLanguageWord != null)
				{
					#region		find next Word Id

					int wordId = -1;
					foreach (BabebiDataSet.WordRow word in this.mainForm.DataSet.Word)
					{
						if (word.RowState == DataRowState.Deleted || word.RowState == DataRowState.Detached)
						{
							continue;
						}

						if (word.Id > wordId)
						{
							wordId = word.Id;
						}
					}
					wordId++;

					#endregion	find next Word Id

					this.mainForm.DataSet.WordOrPattern
						.AddWordOrPatternRow
						(
							MainForm.SubscriberCode_Word,
							wordId
						);

					this.selected__Word
						= this.mainForm.DataSet.Word
						.AddWordRow
						(
							wordId,
							newName,
							this.mainForm.DataSet.WordType.FindById(MainForm.WordTypeId__ProperNoun),
							MainForm.ModeCode_NotDefined,
							false,
							MainForm.SubscriberCode_Word
						);

					this.selected__Word_Language
						= this.mainForm.DataSet.Word_Language
						.AddWord_LanguageRow
						(
							wordId,
							this.current__Language,
							MainForm.WordTypeId__ProperNoun,
							this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString
						);

					word_LanguageWord
						= this.mainForm.DataSet.Word_LanguageWord
						.AddWord_LanguageWordRow
						(
							wordId,
							this.current__Language__Code,
							this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString
						);
				}
				else
				{
					/// cela ne peut arriver que si l'on tente de traduire... une phrase qui n'existe pas !
					/// 
					MessageBox.Show
					(
						"A 'Word (New name)' can not be created because no 'Sentence Language Word' is currently selected.",
						"Not-selected 'Sentence Language Word'", 
						MessageBoxButtons.OK, 
						MessageBoxIcon.Error
					);

					return;
				}
			}

			/// à ce stade : this.selected__Word != null => on crée le SW.

			#region		find next SentenceWord Index

			short sentenceWordIndex = -1;
			foreach (BabebiDataSet.SentenceWordRow sentenceWord in this.mainForm.Current__Sentence.GetSentenceWordRows())
			{
				if (sentenceWord.RowState == DataRowState.Deleted || sentenceWord.RowState == DataRowState.Detached)
				{
					continue;
				}

				if (sentenceWord.Index > sentenceWordIndex)
				{	
					sentenceWordIndex = sentenceWord.Index;
				}
			}
			sentenceWordIndex++;

			#endregion	find next SentenceWord Index

			this.mainForm.Current__SentenceWord 
				= this.mainForm.DataSet
				.SentenceWord
				.AddSentenceWordRow
				(
					this.mainForm.Current__Sentence, 
					sentenceWordIndex, 
					this.selected__Word
				);

			if (word_LanguageWord == null)
			{
				/// W n'est pas pas un Name.
				
				if (this.mainForm.Current__Sentence_LanguageLanguageWord != null)
				{
					word_LanguageWord
						= this.mainForm.DataSet
						.Word_LanguageWord
						.FindByWordIdLanguageCodeLanguageWordString
						(
							this.selected__Word.Id,
							this.current__Language__Code,
							this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString
						);

					if (word_LanguageWord == null)
					{				
						DialogResult dialogResult
							= MessageBox.Show
							(
								"The following link between 'Word' and 'Language Word' is missing:\n\n" + 
								"Word Id = '"					+ this.selected__Word.Id.ToString() + "'\n" +
								"Word Unique Key String = '"	+ this.selected__Word.UniqueKeyString + "'\n" +
								"Word Meaning = '"				+ this.selected__Word_Language.Meaning + "'\n" +
								"Currency Code = '"				+ this.current__Language__Code + "'\n" + 
								"Language Word String = '"		+ this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString + "'\n\n" +
								"Do you want to create it right now ?",
								"Create missing Word_LanguageWord?",
								MessageBoxButtons.YesNo,
								MessageBoxIcon.Question
							);

						if (dialogResult == DialogResult.Yes)
						{
							word_LanguageWord
								= this.mainForm.DataSet
								.Word_LanguageWord
								.AddWord_LanguageWordRow
								(
									this.selected__Word.Id,
									this.current__Language__Code,
									this.mainForm.Current__Sentence_LanguageLanguageWord.LanguageWordString
								);
						}
					}
				}
				else
				{
					word_LanguageWord = null;
				}
			}

			if (word_LanguageWord != null)
			{
				this.mainForm.Current__SentenceWord_LanguageWord
					= this.mainForm.DataSet
					.SentenceWord_LanguageWord
					.AddSentenceWord_LanguageWordRow
					(
						this.mainForm.Current__Sentence.Id,
						this.current__Language__Code,
						this.mainForm.Current__SentenceWord.Index,
						this.mainForm.Current__Sentence_LanguageLanguageWord.Index,
						this.mainForm.Current__SentenceWord.WordId,
						word_LanguageWord.LanguageWordString
					);
			}

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
