﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Babebi4
{
	class Program
	{
		static void Main(string[] args)
		{
			/// Remember : Custom Tool = MSDataSetGenerator => clicker droit sur le fichier .xsd et clicker sur le menu "Executer un outil spécialisé"

			/// Remarques:
			/// 
			/// 1) Après une longue reflexion sur l'utilité ou pas d'avoir une table par concept (frameworl-like), j'ai choisi Framework-like : on ne 
			/// merge donc ni Symbol dans Letter, ni Pattern dans Word ; même si, par code, on aurait pu le faire. La raison est purement religieuse,
			/// bien sûr.
			/// 
			/// 2) Les Columns-Expressions (Exemple : Word_Language.UniqueKeyString) sont finalement très utiles :
			///
			/// - elles permettent souvent d'avoir directement des GuiDataViews bindées sur une DataTable native sans passer par la création/gestion d'une table custom "gui".
			/// - elles permettent de simplifier les requêtes dans les DataTable.Select("...").

			DataSet dataSet = new DataSet("BabebiDataSet")
			{
				Namespace = "Babebi4",
				CaseSensitive = true
			};

			bool doStructure = true;

			if (doStructure)
			{
				#region		[structure]

				#region		LetterOrSymbol (Abstract)

				DataTable dataTable__LetterOrSymbol = dataSet.Tables.Add("LetterOrSymbol");

				#region		String

				DataColumn dataColumn__LetterOrSymbol__String = dataTable__LetterOrSymbol.Columns.Add("String", typeof(string));
				dataColumn__LetterOrSymbol__String.AllowDBNull = false;
				dataColumn__LetterOrSymbol__String.MaxLength = 2;
				dataColumn__LetterOrSymbol__String.ColumnMapping = MappingType.Attribute;

				#endregion	String
				#region		ModeCode

				DataColumn dataColumn__LetterOrSymbol__ModeCode = dataTable__LetterOrSymbol.Columns.Add("ModeCode", typeof(string));
				dataColumn__LetterOrSymbol__ModeCode.AllowDBNull = false;
				dataColumn__LetterOrSymbol__ModeCode.MaxLength = 1;
				dataColumn__LetterOrSymbol__ModeCode.DefaultValue = "L";	/// for Letter; the other value is "S" for Symbol.
				dataColumn__LetterOrSymbol__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode

				dataTable__LetterOrSymbol.PrimaryKey = new DataColumn[] { dataColumn__LetterOrSymbol__String };

				#endregion	LetterOrSymbol (Abstract)
				#region		Language

				DataTable dataTable__Language = dataSet.Tables.Add("Language");

				#region		Code

				DataColumn dataColumn__Language__Code = dataTable__Language.Columns.Add("Code", typeof(string));
				dataColumn__Language__Code.AllowDBNull = false;
				dataColumn__Language__Code.MaxLength = 3;
				dataColumn__Language__Code.ColumnMapping = MappingType.Attribute;

				#endregion	Code
				#region		Name

				DataColumn dataColumn__Language__Name = dataTable__Language.Columns.Add("Name", typeof(string));
				dataColumn__Language__Name.AllowDBNull = false;
				dataColumn__Language__Name.MaxLength = 64;
				dataColumn__Language__Name.Unique = true;
				dataColumn__Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		Words

				DataColumn
				dataColumn__Language__Words = dataTable__Language.Columns.Add("Words", typeof(long));
				dataColumn__Language__Words.AllowDBNull = false;
				dataColumn__Language__Words.DefaultValue = 0;
				dataColumn__Language__Words.ColumnMapping = MappingType.Attribute;

				#endregion	Words
				#region		Meanings

				DataColumn
				dataColumn__Language__Meanings = dataTable__Language.Columns.Add("Meanings", typeof(long));
				dataColumn__Language__Meanings.AllowDBNull = false;
				dataColumn__Language__Meanings.DefaultValue = 0;
				dataColumn__Language__Meanings.ColumnMapping = MappingType.Attribute;

				#endregion	Meanings

				dataTable__Language.PrimaryKey = new DataColumn[] { dataColumn__Language__Code };

				#endregion	Language
				#region		LetterOrSymbol_Language (Link)

				DataTable dataTable__LetterOrSymbol_Language = dataSet.Tables.Add("LetterOrSymbol_Language");

				#region		LetterOrSymbolString

				DataColumn dataColumn__LetterOrSymbol_Language__LetterOrSymbolString = dataTable__LetterOrSymbol_Language.Columns.Add("LetterOrSymbolString", typeof(string));
				dataColumn__LetterOrSymbol_Language__LetterOrSymbolString.AllowDBNull = false;
				dataColumn__LetterOrSymbol_Language__LetterOrSymbolString.MaxLength = 2;
				dataColumn__LetterOrSymbol_Language__LetterOrSymbolString.ColumnMapping = MappingType.Attribute;

				#endregion	LetterOrSymbolString
				#region		LanguageCode

				DataColumn dataColumn__LetterOrSymbol_Language__LanguageCode = dataTable__LetterOrSymbol_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__LetterOrSymbol_Language__LanguageCode.AllowDBNull = false;
				dataColumn__LetterOrSymbol_Language__LanguageCode.MaxLength = 3;
				dataColumn__LetterOrSymbol_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		As

				DataColumn dataColumn__LetterOrSymbol_Language__As = dataTable__LetterOrSymbol_Language.Columns.Add("As", typeof(string));
				dataColumn__LetterOrSymbol_Language__As.AllowDBNull = false;
				dataColumn__LetterOrSymbol_Language__As.MaxLength = 4;
				dataColumn__LetterOrSymbol_Language__As.ColumnMapping = MappingType.Attribute;

				#endregion	As
				#region		In

				DataColumn dataColumn__LetterOrSymbol_Language__In = dataTable__LetterOrSymbol_Language.Columns.Add("In", typeof(string));
				dataColumn__LetterOrSymbol_Language__In.AllowDBNull = false;
				dataColumn__LetterOrSymbol_Language__In.MaxLength = 64;
				dataColumn__LetterOrSymbol_Language__In.ColumnMapping = MappingType.Attribute;

				#endregion	In

				dataTable__LetterOrSymbol_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__LetterOrSymbol_Language__LetterOrSymbolString,
					dataColumn__LetterOrSymbol_Language__LanguageCode
					};

				#region		LetterOrSymbol_Language__LetterOrSymbol

				dataSet.Relations.Add
				(
					"LetterOrSymbol_Language__LetterOrSymbol",
					new DataColumn[] { dataColumn__LetterOrSymbol__String },
					new DataColumn[] { dataColumn__LetterOrSymbol_Language__LetterOrSymbolString }
				);

				#endregion	LetterOrSymbol_Language__LetterOrSymbol
				#region		LetterOrSymbol_Language__Language

				dataSet.Relations.Add
				(
					"LetterOrSymbol_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__LetterOrSymbol_Language__LanguageCode }
				);

				#endregion	LetterOrSymbol_Language__Language

				#endregion	LetterOrSymbol__Language (Link)

				#region		Letter (Mode)

				DataTable dataTable__Letter = dataSet.Tables.Add("Letter");

				#region		String

				DataColumn dataColumn__Letter__String = dataTable__Letter.Columns.Add("String", typeof(string));
				dataColumn__Letter__String.AllowDBNull = false;
				dataColumn__Letter__String.MaxLength = 2;
				dataColumn__Letter__String.ColumnMapping = MappingType.Attribute;

				#endregion	String
				#region		ModeCode

				DataColumn dataColumn__Letter__ModeCode = dataTable__Letter.Columns.Add("ModeCode", typeof(string));
				dataColumn__Letter__ModeCode.AllowDBNull = false;
				dataColumn__Letter__ModeCode.MaxLength = 1;
				dataColumn__Letter__ModeCode.DefaultValue = "L";
				dataColumn__Letter__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		TypeCode

				DataColumn
				dataColumn__Letter__TypeCode = dataTable__Letter.Columns.Add("TypeCode");
				dataColumn__Letter__TypeCode.DataType = typeof(string);
				dataColumn__Letter__TypeCode.MaxLength = 1;
				dataColumn__Letter__TypeCode.AllowDBNull = false;
				dataColumn__Letter__TypeCode.ColumnMapping = MappingType.Attribute;

				#endregion	TypeCode
				#region		Rank

				DataColumn
				dataColumn__Letter__Rank = dataTable__Letter.Columns.Add("Rank");
				dataColumn__Letter__Rank.DataType = typeof(short);
				dataColumn__Letter__Rank.AllowDBNull = false;
				dataColumn__Letter__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank

				dataTable__Letter.PrimaryKey = new DataColumn[] { dataColumn__Letter__String };

				#region		Letter__LetterOrSymbol

				dataSet.Relations.Add
				(
					"Letter__LetterOrSymbol",
					new DataColumn[] 
					{ 
						dataColumn__LetterOrSymbol__String, 
						dataColumn__LetterOrSymbol__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__Letter__String,
						dataColumn__Letter__ModeCode 
					}
				);

				#endregion	Letter__LetterOrSymbol

				#endregion	Letter (Mode)
				#region		Symbol (Mode)

				DataTable dataTable__Symbol = dataSet.Tables.Add("Symbol");

				#region		String

				DataColumn dataColumn__Symbol__String = dataTable__Symbol.Columns.Add("String", typeof(string));
				dataColumn__Symbol__String.AllowDBNull = false;
				dataColumn__Symbol__String.MaxLength = 2;
				dataColumn__Symbol__String.ColumnMapping = MappingType.Attribute;

				#endregion	String
				#region		ModeCode

				DataColumn dataColumn__Symbol__ModeCode = dataTable__Symbol.Columns.Add("ModeCode", typeof(string));
				dataColumn__Symbol__ModeCode.AllowDBNull = false;
				dataColumn__Symbol__ModeCode.MaxLength = 1;
				dataColumn__Symbol__ModeCode.DefaultValue = "S";
				dataColumn__Symbol__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		TypeCode

				DataColumn
				dataColumn__Symbol__TypeCode = dataTable__Symbol.Columns.Add("TypeCode");
				dataColumn__Symbol__TypeCode.DataType = typeof(string);
				dataColumn__Symbol__TypeCode.MaxLength = 1;
				dataColumn__Symbol__TypeCode.AllowDBNull = false;
				dataColumn__Symbol__TypeCode.ColumnMapping = MappingType.Attribute;

				#endregion	TypeCode

				dataTable__Symbol.PrimaryKey = new DataColumn[] { dataColumn__Symbol__String };

				#region		Symbol__LetterOrSymbol

				dataSet.Relations.Add
				(
					"Symbol__LetterOrSymbol",
					new DataColumn[] 
					{ 
						dataColumn__LetterOrSymbol__String, 
						dataColumn__LetterOrSymbol__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__Symbol__String,
						dataColumn__Symbol__ModeCode 
					}
				);

				#endregion	Symbol__LetterOrSymbol

				#endregion	Symbol (Mode)

				#region		LetterCluster

				DataTable dataTable__LetterCluster = dataSet.Tables.Add("LetterCluster");

				#region		Id

				DataColumn dataColumn__LetterCluster__Id = dataTable__LetterCluster.Columns.Add("Id", typeof(int));
				dataColumn__LetterCluster__Id.AllowDBNull = false;
				dataColumn__LetterCluster__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		String

				DataColumn dataColumn__LetterCluster__String = dataTable__LetterCluster.Columns.Add("String", typeof(string));
				dataColumn__LetterCluster__String.AllowDBNull = false;
				dataColumn__LetterCluster__String.MaxLength = 32;
				dataColumn__LetterCluster__String.ColumnMapping = MappingType.Attribute;
				dataColumn__LetterCluster__String.Unique = true;

				#endregion	String

				dataTable__LetterCluster.PrimaryKey = new DataColumn[] { dataColumn__LetterCluster__Id };

				#endregion	LetterCluster
				#region		LetterClusterLetter

				DataTable dataTable__LetterClusterLetter = dataSet.Tables.Add("LetterClusterLetter");

				#region		LetterClusterId

				DataColumn dataColumn__LetterClusterLetter__LetterClusterId = dataTable__LetterClusterLetter.Columns.Add("LetterClusterId", typeof(int));
				dataColumn__LetterClusterLetter__LetterClusterId.AllowDBNull = false;
				dataColumn__LetterClusterLetter__LetterClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterClusterId
				#region		Rank

				DataColumn dataColumn__LetterClusterLetter__Rank = dataTable__LetterClusterLetter.Columns.Add("Rank", typeof(short));
				dataColumn__LetterClusterLetter__Rank.AllowDBNull = false;
				dataColumn__LetterClusterLetter__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank
				#region		LetterString

				DataColumn dataColumn__LetterClusterLetter__LetterString = dataTable__LetterClusterLetter.Columns.Add("LetterString", typeof(string));
				dataColumn__LetterClusterLetter__LetterString.AllowDBNull = false;
				dataColumn__LetterClusterLetter__LetterString.MaxLength = 32;
				dataColumn__LetterClusterLetter__LetterString.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__LetterClusterLetter.PrimaryKey = new DataColumn[] 
					{ 
						dataColumn__LetterClusterLetter__LetterClusterId, 
						dataColumn__LetterClusterLetter__Rank 
					};

				#region		LetterClusterLetter__LetterCluster

				dataSet.Relations.Add
				(
					"LetterClusterLetter__LetterCluster",
					new DataColumn[] { dataColumn__LetterCluster__Id },
					new DataColumn[] { dataColumn__LetterClusterLetter__LetterClusterId }
				);

				#endregion	LetterClusterLetter__LetterCluster
				#region		LetterClusterLetter__Letter

				dataSet.Relations.Add
				(
					"LetterClusterLetter__Letter",
					new DataColumn[] { dataColumn__Letter__String },
					new DataColumn[] { dataColumn__LetterClusterLetter__LetterString }
				);

				#endregion	LetterClusterLetter__Letter



				#endregion	LetterClusterLetter

				#region		SymbolCluster

				DataTable dataTable__SymbolCluster = dataSet.Tables.Add("SymbolCluster");

				#region		Id

				DataColumn dataColumn__SymbolCluster__Id = dataTable__SymbolCluster.Columns.Add("Id", typeof(int));
				dataColumn__SymbolCluster__Id.AllowDBNull = false;
				dataColumn__SymbolCluster__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		String

				DataColumn dataColumn__SymbolCluster__String = dataTable__SymbolCluster.Columns.Add("String", typeof(string));
				dataColumn__SymbolCluster__String.AllowDBNull = false;
				dataColumn__SymbolCluster__String.MaxLength = 32;
				dataColumn__SymbolCluster__String.ColumnMapping = MappingType.Attribute;
				dataColumn__SymbolCluster__String.Unique = true;

				#endregion	String

				dataTable__SymbolCluster.PrimaryKey = new DataColumn[] { dataColumn__SymbolCluster__Id };

				#endregion	SymbolCluster
				#region		SymbolClusterSymbol

				DataTable dataTable__SymbolClusterSymbol = dataSet.Tables.Add("SymbolClusterSymbol");

				#region		SymbolClusterId

				DataColumn dataColumn__SymbolClusterSymbol__SymbolClusterId = dataTable__SymbolClusterSymbol.Columns.Add("SymbolClusterId", typeof(int));
				dataColumn__SymbolClusterSymbol__SymbolClusterId.AllowDBNull = false;
				dataColumn__SymbolClusterSymbol__SymbolClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	SymbolClusterId
				#region		Rank

				DataColumn dataColumn__SymbolClusterSymbol__Rank = dataTable__SymbolClusterSymbol.Columns.Add("Rank", typeof(short));
				dataColumn__SymbolClusterSymbol__Rank.AllowDBNull = false;
				dataColumn__SymbolClusterSymbol__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank
				#region		SymbolString

				DataColumn dataColumn__SymbolClusterSymbol__SymbolString = dataTable__SymbolClusterSymbol.Columns.Add("SymbolString", typeof(string));
				dataColumn__SymbolClusterSymbol__SymbolString.AllowDBNull = false;
				dataColumn__SymbolClusterSymbol__SymbolString.MaxLength = 32;
				dataColumn__SymbolClusterSymbol__SymbolString.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__SymbolClusterSymbol.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__SymbolClusterSymbol__SymbolClusterId, 
						dataColumn__SymbolClusterSymbol__Rank 
					};

				#region		SymbolClusterSymbol__SymbolCluster

				dataSet.Relations.Add
				(
					"SymbolClusterSymbol__SymbolCluster",
					new DataColumn[] { dataColumn__SymbolCluster__Id },
					new DataColumn[] { dataColumn__SymbolClusterSymbol__SymbolClusterId }
				);

				#endregion	SymbolClusterSymbol__SymbolCluster
				#region		SymbolClusterSymbol__Symbol

				dataSet.Relations.Add
				(
					"SymbolClusterSymbol__Symbol",
					new DataColumn[] { dataColumn__Symbol__String },
					new DataColumn[] { dataColumn__SymbolClusterSymbol__SymbolString }
				);

				#endregion	SymbolClusterSymbol__Symbol

				#endregion	SymbolClusterSymbol

				#region		LetterOrSymbolCluster

				DataTable dataTable__LetterOrSymbolCluster = dataSet.Tables.Add("LetterOrSymbolCluster");

				#region		Id

				DataColumn dataColumn__LetterOrSymbolCluster__Id = dataTable__LetterOrSymbolCluster.Columns.Add("Id", typeof(int));
				dataColumn__LetterOrSymbolCluster__Id.AllowDBNull = false;
				dataColumn__LetterOrSymbolCluster__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		String

				DataColumn dataColumn__LetterOrSymbolCluster__String = dataTable__LetterOrSymbolCluster.Columns.Add("String", typeof(string));
				dataColumn__LetterOrSymbolCluster__String.AllowDBNull = false;
				dataColumn__LetterOrSymbolCluster__String.MaxLength = 32;
				dataColumn__LetterOrSymbolCluster__String.ColumnMapping = MappingType.Attribute;
				dataColumn__LetterOrSymbolCluster__String.Unique = true;

				#endregion	String

				dataTable__LetterOrSymbolCluster.PrimaryKey = new DataColumn[] { dataColumn__LetterOrSymbolCluster__Id };

				#endregion	LetterOrSymbolCluster
				#region		LetterOrSymbolClusterLetterOrSymbol

				DataTable dataTable__LetterOrSymbolClusterLetterOrSymbol = dataSet.Tables.Add("LetterOrSymbolClusterLetterOrSymbol");

				#region		LetterOrSymbolClusterId

				DataColumn dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolClusterId = dataTable__LetterOrSymbolClusterLetterOrSymbol.Columns.Add("LetterOrSymbolClusterId", typeof(int));
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolClusterId.AllowDBNull = false;
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterOrSymbolClusterId
				#region		Rank

				DataColumn dataColumn__LetterOrSymbolClusterLetterOrSymbol__Rank = dataTable__LetterOrSymbolClusterLetterOrSymbol.Columns.Add("Rank", typeof(short));
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__Rank.AllowDBNull = false;
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank
				#region		LetterOrSymbolString

				DataColumn dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolString = dataTable__LetterOrSymbolClusterLetterOrSymbol.Columns.Add("LetterOrSymbolString", typeof(string));
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolString.AllowDBNull = false;
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolString.MaxLength = 32;
				dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolString.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__LetterOrSymbolClusterLetterOrSymbol.PrimaryKey = new DataColumn[] 
					{ 
						dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolClusterId, 
						dataColumn__LetterOrSymbolClusterLetterOrSymbol__Rank 
					};

				#region		LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolCluster

				dataSet.Relations.Add
				(
					"LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolCluster",
					new DataColumn[] { dataColumn__LetterOrSymbolCluster__Id },
					new DataColumn[] { dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolClusterId }
				);

				#endregion	LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolCluster
				#region		LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbol

				dataSet.Relations.Add
				(
					"LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbol",
					new DataColumn[] { dataColumn__LetterOrSymbol__String },
					new DataColumn[] { dataColumn__LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbolString }
				);

				#endregion	LetterOrSymbolClusterLetterOrSymbol__LetterOrSymbol



				#endregion	LetterOrSymbolClusterLetterOrSymbol

				#region		WordType

				DataTable dataTable__WordType = dataSet.Tables.Add("WordType");

				#region		Id

				DataColumn
				dataColumn__WordType__Id = dataTable__WordType.Columns.Add("Id", typeof(short));
				dataColumn__WordType__Id.AllowDBNull = false;
				dataColumn__WordType__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		Name

				DataColumn dataColumn__WordType__Name = dataTable__WordType.Columns.Add("Name", typeof(string));
				dataColumn__WordType__Name.AllowDBNull = true;
				dataColumn__WordType__Name.MaxLength = 256;
				dataColumn__WordType__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name

				dataTable__WordType.PrimaryKey = new DataColumn[] { dataColumn__WordType__Id };

				#endregion	WordType
				#region		WordType_Language

				DataTable dataTable__WordType_Language = dataSet.Tables.Add("WordType_Language");

				#region		WordTypeId

				DataColumn
				dataColumn__WordType_Language__WordTypeId = dataTable__WordType_Language.Columns.Add("WordTypeId", typeof(short));
				dataColumn__WordType_Language__WordTypeId.AllowDBNull = false;
				dataColumn__WordType_Language__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		LanguageCode

				DataColumn
				dataColumn__WordType_Language__LanguageCode = dataTable__WordType_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__WordType_Language__LanguageCode.AllowDBNull = false;
				dataColumn__WordType_Language__LanguageCode.MaxLength = 3;
				dataColumn__WordType_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Name

				DataColumn
				dataColumn__WordType_Language__Name = dataTable__WordType_Language.Columns.Add("Name", typeof(string));
				dataColumn__WordType_Language__Name.AllowDBNull = true;
				dataColumn__WordType_Language__Name.MaxLength = 256;
				dataColumn__WordType_Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name

				dataTable__WordType_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__WordType_Language__WordTypeId,
					dataColumn__WordType_Language__LanguageCode
					};

				#region		WordType_Language__WordType

				dataSet.Relations.Add
				(
					"WordType_Language__WordType",
					new DataColumn[] { dataColumn__WordType__Id },
					new DataColumn[] { dataColumn__WordType_Language__WordTypeId }
				);

				#endregion	WordType_Language__WordType
				#region		WordType_Language__Language

				dataSet.Relations.Add
				(
					"WordType_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__WordType_Language__LanguageCode }
				);

				#endregion	WordType_Language__Language

				#endregion	WordType_Language

				#region		DerivatingWordType

				DataTable dataTable__DerivatingWordType = dataSet.Tables.Add("DerivatingWordType");

				#region		Id

				DataColumn
				dataColumn__DerivatingWordType__Id = dataTable__DerivatingWordType.Columns.Add("Id", typeof(short));
				dataColumn__DerivatingWordType__Id.AllowDBNull = false;
				dataColumn__DerivatingWordType__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		Name

				DataColumn dataColumn__DerivatingWordType__Name = dataTable__DerivatingWordType.Columns.Add("Name", typeof(string));
				dataColumn__DerivatingWordType__Name.AllowDBNull = true;
				dataColumn__DerivatingWordType__Name.MaxLength = 256;
				dataColumn__DerivatingWordType__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		WordTypeId

				DataColumn
				dataColumn__DerivatingWordType__WordTypeId = dataTable__DerivatingWordType.Columns.Add("WordTypeId", typeof(short));
				dataColumn__DerivatingWordType__WordTypeId.AllowDBNull = false;
				dataColumn__DerivatingWordType__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId

				dataTable__DerivatingWordType.PrimaryKey = new DataColumn[] { dataColumn__DerivatingWordType__Id };

				#region		DerivatingWordType_WordType

				dataSet.Relations.Add
				(
					"DerivatingWordType_WordType",
					new DataColumn[] { dataColumn__WordType__Id },
					new DataColumn[] { dataColumn__DerivatingWordType__WordTypeId }
				);

				#endregion	DerivatingWordType_WordType

				#endregion	DerivatingWordType
				#region		DerivatingWordType_Language

				DataTable dataTable__DerivatingWordType_Language = dataSet.Tables.Add("DerivatingWordType_Language");

				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__DerivatingWordType_Language__DerivatingWordTypeId = dataTable__DerivatingWordType_Language.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__DerivatingWordType_Language__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__DerivatingWordType_Language__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingWordTypeId
				#region		LanguageCode

				DataColumn
				dataColumn__DerivatingWordType_Language__LanguageCode = dataTable__DerivatingWordType_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__DerivatingWordType_Language__LanguageCode.AllowDBNull = false;
				dataColumn__DerivatingWordType_Language__LanguageCode.MaxLength = 3;
				dataColumn__DerivatingWordType_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Name

				DataColumn
				dataColumn__DerivatingWordType_Language__Name = dataTable__DerivatingWordType_Language.Columns.Add("Name", typeof(string));
				dataColumn__DerivatingWordType_Language__Name.AllowDBNull = true;
				dataColumn__DerivatingWordType_Language__Name.MaxLength = 256;
				dataColumn__DerivatingWordType_Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		WordTypeId

				DataColumn
				dataColumn__DerivatingWordType_Language__WordTypeId = dataTable__DerivatingWordType_Language.Columns.Add("WordTypeId", typeof(short));
				dataColumn__DerivatingWordType_Language__WordTypeId.AllowDBNull = false;
				dataColumn__DerivatingWordType_Language__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		DerivatingWordTypeName	(Expression)

				DataColumn
				dataColumn__DerivatingWordType_Language__DerivatingWordTypeName = dataTable__DerivatingWordType_Language.Columns.Add("DerivatingWordTypeName", typeof(string));
				dataColumn__DerivatingWordType_Language__DerivatingWordTypeName.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatingWordTypeName	(Expression)
				#region		WordType_LanguageName	(Expression)

				DataColumn
				dataColumn__DerivatingWordType_Language__WordType_LanguageName = dataTable__DerivatingWordType_Language.Columns.Add("WordType_LanguageName", typeof(string));
				dataColumn__DerivatingWordType_Language__WordType_LanguageName.ColumnMapping = MappingType.Hidden;

				#endregion	WordType_LanguageName	(Expression)

				dataTable__DerivatingWordType_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__DerivatingWordType_Language__DerivatingWordTypeId,
					dataColumn__DerivatingWordType_Language__LanguageCode
					};

				#region		DerivatingWordType_Language__DerivatingWordType

				dataSet.Relations.Add
				(
					"DerivatingWordType_Language__DerivatingWordType",
					new DataColumn[] 
					{ 
						dataColumn__DerivatingWordType__Id, 
						dataColumn__DerivatingWordType__WordTypeId						/// pour l'Update-Cascade.
					},
					new DataColumn[] 
					{ 
						dataColumn__DerivatingWordType_Language__DerivatingWordTypeId,
						dataColumn__DerivatingWordType_Language__WordTypeId				/// pour l'Update-Cascade.
					}
				);

				#endregion	DerivatingWordType_Language__DerivatingWordType
				#region		DerivatingWordType_Language__Language

				dataSet.Relations.Add
				(
					"DerivatingWordType_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__DerivatingWordType_Language__LanguageCode }
				);

				#endregion	DerivatingWordType_Language__Language
				#region		DerivatingWordType_Language__WordType_Language

				dataSet.Relations.Add
				(
					"DerivatingWordType_Language__WordType_Language",
					new DataColumn[]
					{
					dataColumn__WordType_Language__WordTypeId,
					dataColumn__WordType_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__DerivatingWordType_Language__WordTypeId,
					dataColumn__DerivatingWordType_Language__LanguageCode
					}
				);

				#endregion	DerivatingWordType_Language__WordType_Language

				dataColumn__DerivatingWordType_Language__DerivatingWordTypeName.Expression = "Parent(DerivatingWordType_Language__DerivatingWordType).Name";
				dataColumn__DerivatingWordType_Language__WordType_LanguageName.Expression = "Parent(DerivatingWordType_Language__WordType_Language).Name";

				#endregion	DerivatingWordType_Language
				#region		DerivatedWordType

				DataTable dataTable__DerivatedWordType = dataSet.Tables.Add("DerivatedWordType");

				#region		Id

				DataColumn
				dataColumn__DerivatedWordType__Id = dataTable__DerivatedWordType.Columns.Add("Id", typeof(short));
				dataColumn__DerivatedWordType__Id.AllowDBNull = false;
				dataColumn__DerivatedWordType__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		Name

				DataColumn dataColumn__DerivatedWordType__Name = dataTable__DerivatedWordType.Columns.Add("Name", typeof(string));
				dataColumn__DerivatedWordType__Name.AllowDBNull = true;
				dataColumn__DerivatedWordType__Name.MaxLength = 256;
				dataColumn__DerivatedWordType__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		WordTypeId

				DataColumn
				dataColumn__DerivatedWordType__WordTypeId = dataTable__DerivatedWordType.Columns.Add("WordTypeId", typeof(short));
				dataColumn__DerivatedWordType__WordTypeId.AllowDBNull = false;
				dataColumn__DerivatedWordType__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId

				dataTable__DerivatedWordType.PrimaryKey = new DataColumn[] { dataColumn__DerivatedWordType__Id };

				#region		DerivatedWordType_WordType

				dataSet.Relations.Add
				(
					"DerivatedWordType_WordType",
					new DataColumn[] { dataColumn__WordType__Id },
					new DataColumn[] { dataColumn__DerivatedWordType__WordTypeId }
				);

				#endregion	DerivatedWordType_WordType

				#endregion	DerivatedWordType
				#region		DerivatedWordType_Language

				DataTable dataTable__DerivatedWordType_Language = dataSet.Tables.Add("DerivatedWordType_Language");

				#region		DerivatedWordTypeId

				DataColumn
				dataColumn__DerivatedWordType_Language__DerivatedWordTypeId = dataTable__DerivatedWordType_Language.Columns.Add("DerivatedWordTypeId", typeof(short));
				dataColumn__DerivatedWordType_Language__DerivatedWordTypeId.AllowDBNull = false;
				dataColumn__DerivatedWordType_Language__DerivatedWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId
				#region		LanguageCode

				DataColumn
				dataColumn__DerivatedWordType_Language__LanguageCode = dataTable__DerivatedWordType_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__DerivatedWordType_Language__LanguageCode.AllowDBNull = false;
				dataColumn__DerivatedWordType_Language__LanguageCode.MaxLength = 3;
				dataColumn__DerivatedWordType_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Name

				DataColumn
				dataColumn__DerivatedWordType_Language__Name = dataTable__DerivatedWordType_Language.Columns.Add("Name", typeof(string));
				dataColumn__DerivatedWordType_Language__Name.AllowDBNull = true;
				dataColumn__DerivatedWordType_Language__Name.MaxLength = 256;
				dataColumn__DerivatedWordType_Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		WordTypeId // (Expression)

				DataColumn
				dataColumn__DerivatedWordType_Language__WordTypeId = dataTable__DerivatedWordType_Language.Columns.Add("WordTypeId", typeof(short));
				dataColumn__DerivatedWordType_Language__WordTypeId.AllowDBNull = false;
				dataColumn__DerivatedWordType_Language__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId // (Expression)
				#region		DerivatedWordTypeName (Expression)

				DataColumn
				dataColumn__DerivatedWordType_Language__DerivatedWordTypeName = dataTable__DerivatedWordType_Language.Columns.Add("DerivatedWordTypeName", typeof(string));
				dataColumn__DerivatedWordType_Language__DerivatedWordTypeName.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatedWordTypeName (Expression)
				#region		WordType_LanguageName (Expression)

				DataColumn
				dataColumn__DerivatedWordType_Language__WordType_LanguageName = dataTable__DerivatedWordType_Language.Columns.Add("WordType_LanguageName", typeof(string));
				dataColumn__DerivatedWordType_Language__WordType_LanguageName.ColumnMapping = MappingType.Hidden;

				#endregion	WordType_LanguageName (Expression)

				dataTable__DerivatedWordType_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__DerivatedWordType_Language__DerivatedWordTypeId,
					dataColumn__DerivatedWordType_Language__LanguageCode
					};

				#region		DerivatedWordType_Language__DerivatedWordType

				dataSet.Relations.Add
				(
					"DerivatedWordType_Language__DerivatedWordType",
					new DataColumn[] 
					{ 
						dataColumn__DerivatedWordType__Id,
						dataColumn__DerivatedWordType__WordTypeId
					},
					new DataColumn[] 
					{ 
						dataColumn__DerivatedWordType_Language__DerivatedWordTypeId,
						dataColumn__DerivatedWordType_Language__WordTypeId
					}
				);

				#endregion	DerivatedWordType_Language__DerivatedWordType
				#region		DerivatedWordType_Language__Language

				dataSet.Relations.Add
				(
					"DerivatedWordType_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__DerivatedWordType_Language__LanguageCode }
				);

				#endregion	DerivatedWordType_Language__Language
				#region		DerivatedWordType_Language__WordType_Language

				dataSet.Relations.Add
				(
					"DerivatedWordType_Language__WordType_Language",
					new DataColumn[]
					{
					dataColumn__WordType_Language__WordTypeId,
					dataColumn__WordType_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__DerivatedWordType_Language__WordTypeId,
					dataColumn__DerivatedWordType_Language__LanguageCode
					}
				);

				#endregion	DerivatedWordType_Language__WordType_Language

				dataColumn__DerivatedWordType_Language__DerivatedWordTypeName	.Expression = "Parent(DerivatedWordType_Language__DerivatedWordType).Name";
			//	dataColumn__DerivatedWordType_Language__WordTypeId				.Expression = "Parent(DerivatedWordType_Language__DerivatedWordType).WordTypeId";
				dataColumn__DerivatedWordType_Language__WordType_LanguageName	.Expression = "Parent(DerivatedWordType_Language__WordType_Language).Name";

				#endregion	DerivatedWordType_Language
				#region		DerivatingWordType_DerivatedWordType

				DataTable dataTable__DerivatingWordType_DerivatedWordType = dataSet.Tables.Add("DerivatingWordType_DerivatedWordType");

				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId = dataTable__DerivatingWordType_DerivatedWordType.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingWordTypeId
				#region		DerivatedWordTypeId

				DataColumn
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId = dataTable__DerivatingWordType_DerivatedWordType.Columns.Add("DerivatedWordTypeId", typeof(short));
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId.AllowDBNull = false;
				dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId

				dataTable__DerivatingWordType_DerivatedWordType.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId,
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId
					};

				#region		DerivatingWordType_DerivatedWordType__DerivatingWordType

				dataSet.Relations.Add
				(
					"DerivatingWordType_DerivatedWordType__DerivatingWordType",
					new DataColumn[] { dataColumn__DerivatingWordType__Id },
					new DataColumn[] { dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId }
				);

				#endregion	DerivatingWordType_DerivatedWordType__DerivatingWordType
				#region		DerivatingWordType_DerivatedWordType__DerivatedWordType

				dataSet.Relations.Add
				(
					"DerivatingWordType_DerivatedWordType__DerivatedWordType",
					new DataColumn[]
					{
					dataColumn__DerivatedWordType__Id
					},
					new DataColumn[]
					{
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId
					}
				);

				#endregion	DerivatingWordType_DerivatedWordType__DerivatingWordType__Derivated

				#endregion	DerivatingWordType_DerivatedWordType__DerivatedWordType
				#region		Derivating

				DataTable dataTable__Derivating = dataSet.Tables.Add("Derivating");

				#region		Id

				DataColumn
				dataColumn__Derivating__Id = dataTable__Derivating.Columns.Add("Id", typeof(short));
				dataColumn__Derivating__Id.AllowDBNull = false;
				dataColumn__Derivating__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__Derivating__DerivatingWordTypeId = dataTable__Derivating.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__Derivating__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__Derivating__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingWordTypeId
				#region		DerivatedWordTypeId

				DataColumn
				dataColumn__Derivating__DerivatedWordTypeId = dataTable__Derivating.Columns.Add("DerivatedWordTypeId", typeof(short));
				dataColumn__Derivating__DerivatedWordTypeId.AllowDBNull = false;
				dataColumn__Derivating__DerivatedWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId
				#region		Name

				DataColumn
				dataColumn__Derivating__Name = dataTable__Derivating.Columns.Add("Name", typeof(string));
				dataColumn__Derivating__Name.AllowDBNull = false;
				dataColumn__Derivating__Name.MaxLength = 256;
				dataColumn__Derivating__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		LetterClusterId

				DataColumn
				dataColumn__Derivating__LetterClusterId = dataTable__Derivating.Columns.Add("LetterClusterId", typeof(int));
				dataColumn__Derivating__LetterClusterId.AllowDBNull = false;
				dataColumn__Derivating__LetterClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterClusterId
				#region		AppendStringAtLast

				DataColumn
				dataColumn__Derivating__AppendStringAtLast = dataTable__Derivating.Columns.Add("AppendStringAtLast", typeof(bool));
				dataColumn__Derivating__AppendStringAtLast.AllowDBNull = false;
				dataColumn__Derivating__AppendStringAtLast.DefaultValue = true;
				dataColumn__Derivating__AppendStringAtLast.ColumnMapping = MappingType.Attribute;

				#endregion	AppendStringAtLast
				#region		LetterClusterString

				DataColumn
				dataColumn__Derivating__LetterClusterString = dataTable__Derivating.Columns.Add("LetterClusterString", typeof(string));
				dataColumn__Derivating__LetterClusterString.ColumnMapping = MappingType.Hidden;

				#endregion	LetterClusterString

				dataTable__Derivating.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__Derivating__Id
					};

				#region		Derivating__DerivatingWordType_DerivatedWordType

				dataSet.Relations.Add
				(
					"Derivating__DerivatingWordType_DerivatedWordType",
					new DataColumn[]
					{
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId,
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId
					},
					new DataColumn[]
					{
					dataColumn__Derivating__DerivatingWordTypeId,
					dataColumn__Derivating__DerivatedWordTypeId
					}
				);

				#endregion	Derivating__DerivatingWordType__Derivating
				#region		Derivating__LetterCluster

				dataSet.Relations.Add
				(
					"Derivating__LetterCluster",
					new DataColumn[]
					{
						dataColumn__LetterCluster__Id
					},
					new DataColumn[]
					{
						dataColumn__Derivating__LetterClusterId
					}
				);

				#endregion	Derivating__LetterCluster

				dataColumn__Derivating__LetterClusterString.Expression = "Parent(Derivating__LetterCluster).String";

				#endregion	Derivating
				#region		Derivating_Language

				DataTable dataTable__Derivating_Language = dataSet.Tables.Add("Derivating_Language");

				#region		DerivatingId

				DataColumn
				dataColumn__Derivating_Language__DerivatingId = dataTable__Derivating_Language.Columns.Add("DerivatingId", typeof(short));
				dataColumn__Derivating_Language__DerivatingId.AllowDBNull = false;
				dataColumn__Derivating_Language__DerivatingId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingId
				#region		LanguageCode

				DataColumn
				dataColumn__Derivating_Language__LanguageCode = dataTable__Derivating_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Derivating_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Derivating_Language__LanguageCode.MaxLength = 3;
				dataColumn__Derivating_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Name

				DataColumn
				dataColumn__Derivating_Language__Name = dataTable__Derivating_Language.Columns.Add("Name", typeof(string));
				dataColumn__Derivating_Language__Name.AllowDBNull = false;
				dataColumn__Derivating_Language__Name.MaxLength = 256;
				dataColumn__Derivating_Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name
				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__Derivating_Language__DerivatingWordTypeId = dataTable__Derivating_Language.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__Derivating_Language__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__Derivating_Language__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingWordTypeId
				#region		DerivatedWordTypeId

				DataColumn
				dataColumn__Derivating_Language__DerivatedWordTypeId = dataTable__Derivating_Language.Columns.Add("DerivatedWordTypeId", typeof(short));
				dataColumn__Derivating_Language__DerivatedWordTypeId.AllowDBNull = false;
				dataColumn__Derivating_Language__DerivatedWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId

				/// Expressions
				#region		DerivatingName

				DataColumn
				dataColumn__Derivating_Language__DerivatingName = dataTable__Derivating_Language.Columns.Add("DerivatingName", typeof(string));
				dataColumn__Derivating_Language__DerivatingName.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatingName
				#region		DerivatingLetterClusterString 

				DataColumn
				dataColumn__Derivating_Language__DerivatingLetterClusterString = dataTable__Derivating_Language.Columns.Add("DerivatingLetterClusterString", typeof(string));
				dataColumn__Derivating_Language__DerivatingLetterClusterString.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatingLetterClusterString 
				#region		DerivatingAppendStringAtLast

				DataColumn
				dataColumn__Derivating_Language__DerivatingAppendStringAtLast = dataTable__Derivating_Language.Columns.Add("DerivatingAppendStringAtLast", typeof(bool));
				dataColumn__Derivating_Language__DerivatingAppendStringAtLast.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatingAppendStringAtLast
				#region		DerivatingWordType_LanguageName

				DataColumn
				dataColumn__Derivating_Language__DerivatingWordType_LanguageName = dataTable__Derivating_Language.Columns.Add("DerivatingWordType_LanguageName", typeof(string));
				dataColumn__Derivating_Language__DerivatingWordType_LanguageName.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatingWordType_LanguageName
				#region		DerivatedWordType_LanguageName

				DataColumn
				dataColumn__Derivating_Language__DerivatedWordType_LanguageName = dataTable__Derivating_Language.Columns.Add("DerivatedWordType_LanguageName", typeof(string));
				dataColumn__Derivating_Language__DerivatedWordType_LanguageName.ColumnMapping = MappingType.Hidden;

				#endregion	DerivatedWordType_LanguageName

				dataTable__Derivating_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__Derivating_Language__DerivatingId,
					dataColumn__Derivating_Language__LanguageCode
					};

				#region		Derivating_Language__Derivating

				dataSet.Relations.Add
				(
					"Derivating_Language__Derivating",
					new DataColumn[]
					{
					dataColumn__Derivating__Id,
					dataColumn__Derivating__DerivatingWordTypeId,
					dataColumn__Derivating__DerivatedWordTypeId
					},
					new DataColumn[]
					{
					dataColumn__Derivating_Language__DerivatingId,
					dataColumn__Derivating_Language__DerivatingWordTypeId,
					dataColumn__Derivating_Language__DerivatedWordTypeId
					}
				);

				#endregion	Derivating_Language__Derivating
				#region		Derivating_Language__Language

				dataSet.Relations.Add
				(
					"Derivating_Language__Language",
					new DataColumn[]
					{
					dataColumn__Language__Code
					},
					new DataColumn[]
					{
					dataColumn__Derivating_Language__LanguageCode
					}
				);

				#endregion	Derivating_Language__Language
				#region		Derivating_Language__DerivatingWordType_Language

				dataSet.Relations.Add
				(
					"Derivating_Language__DerivatingWordType_Language",
					new DataColumn[]
					{
					dataColumn__DerivatingWordType_Language__DerivatingWordTypeId,
					dataColumn__DerivatingWordType_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__Derivating_Language__DerivatingWordTypeId,
					dataColumn__Derivating_Language__LanguageCode
					}
				);

				#endregion	Derivating_Language__DerivatingWordType_Language
				#region		Derivating_Language__DerivatedWordType_Language

				dataSet.Relations.Add
				(
					"Derivating_Language__DerivatedWordType_Language",
					new DataColumn[]
					{
					dataColumn__DerivatedWordType_Language__DerivatedWordTypeId,
					dataColumn__DerivatedWordType_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__Derivating_Language__DerivatedWordTypeId,
					dataColumn__Derivating_Language__LanguageCode
					}
				);

				#endregion	Derivating_Language__DerivatedWordType_Language

				dataColumn__Derivating_Language__DerivatingName					.Expression = "Parent(Derivating_Language__Derivating).Name";
				dataColumn__Derivating_Language__DerivatingLetterClusterString	.Expression = "Parent(Derivating_Language__Derivating).LetterClusterString";
				dataColumn__Derivating_Language__DerivatingAppendStringAtLast	.Expression = "Parent(Derivating_Language__Derivating).AppendStringAtLast";
				dataColumn__Derivating_Language__DerivatingWordType_LanguageName.Expression = "Parent(Derivating_Language__DerivatingWordType_Language).Name";
				dataColumn__Derivating_Language__DerivatedWordType_LanguageName	.Expression = "Parent(Derivating_Language__DerivatedWordType_Language).Name";

				#endregion	Derivating_Language


				#region		WordOrPattern (11P)

				DataTable dataTable__WordOrPattern = dataSet.Tables.Add("WordOrPattern");

				#region		SubscriberCode

				DataColumn
				dataColumn__WordOrPattern__SubscriberCode = dataTable__WordOrPattern.Columns.Add("SubscriberCode", typeof(string));
				dataColumn__WordOrPattern__SubscriberCode.AllowDBNull = false;
				dataColumn__WordOrPattern__SubscriberCode.MaxLength = 1;
				dataColumn__WordOrPattern__SubscriberCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscriberCode
				#region		SubscriberId

				DataColumn
				dataColumn__WordOrPattern__SubscriberId = dataTable__WordOrPattern.Columns.Add("SubscriberId", typeof(Int32));
				dataColumn__WordOrPattern__SubscriberId.AllowDBNull = false;
				dataColumn__WordOrPattern__SubscriberId.ColumnMapping = MappingType.Attribute;

				#endregion	SubscriberId

				dataTable__WordOrPattern.PrimaryKey = new DataColumn[] { dataColumn__WordOrPattern__SubscriberCode, dataColumn__WordOrPattern__SubscriberId };

				#endregion	WordOrPattern (11P)


				#region		Pattern

				DataTable dataTable__Pattern = dataSet.Tables.Add("Pattern");

				#region		Id

				DataColumn
				dataColumn__Pattern__Id = dataTable__Pattern.Columns.Add("Id");
				dataColumn__Pattern__Id.DataType = typeof(Int32);
				dataColumn__Pattern__Id.AllowDBNull = false;
				dataColumn__Pattern__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		UniqueKeyString

				DataColumn
				dataColumn__Pattern__UniqueKeyString = dataTable__Pattern.Columns.Add("UniqueKeyString", typeof(string));
				dataColumn__Pattern__UniqueKeyString.AllowDBNull = false;
				dataColumn__Pattern__UniqueKeyString.MaxLength = 32;
				dataColumn__Pattern__UniqueKeyString.ColumnMapping = MappingType.Attribute;
				dataColumn__Pattern__UniqueKeyString.Unique = true;

				#endregion	UniqueKeyString
				#region		ModeCode	: "X" = ExNihilo ; "I" = ByInsertion ;"P" = FromPattern ;

				DataColumn 
				dataColumn__Pattern__ModeCode = dataTable__Pattern.Columns.Add("ModeCode", typeof(string));
				dataColumn__Pattern__ModeCode.AllowDBNull = false;
				dataColumn__Pattern__ModeCode.MaxLength = 1;
				dataColumn__Pattern__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		SubscribingCode

				DataColumn
				dataColumn__Pattern__SubscribingCode = dataTable__Pattern.Columns.Add("SubscribingCode");
				dataColumn__Pattern__SubscribingCode.DataType = typeof(string);
				dataColumn__Pattern__SubscribingCode.AllowDBNull = false;
				dataColumn__Pattern__SubscribingCode.DefaultValue = "P";
				dataColumn__Pattern__SubscribingCode.MaxLength = 1;
				dataColumn__Pattern__SubscribingCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscribingCode


				dataTable__Pattern.PrimaryKey = new DataColumn[] { dataColumn__Pattern__Id };

				#region		Pattern_WordOrPattern

				dataSet.Relations.Add
				(
					"Pattern_WordOrPattern",
					new DataColumn[] 
					{ 
					dataColumn__WordOrPattern__SubscriberCode, 
					dataColumn__WordOrPattern__SubscriberId 
					},
					new DataColumn[] 
					{ 
					dataColumn__Pattern__SubscribingCode, 
					dataColumn__Pattern__Id 
					}
				);

				#endregion	Pattern_WordOrPattern

				#endregion	Pattern
				#region		Pattern_Language

				DataTable dataTable__Pattern_Language = dataSet.Tables.Add("Pattern_Language");

				#region		PatternId

				DataColumn
				dataColumn__Pattern_Language__PatternId = dataTable__Pattern_Language.Columns.Add("PatternId", typeof(Int32));
				dataColumn__Pattern_Language__PatternId.AllowDBNull = false;
				dataColumn__Pattern_Language__PatternId.ColumnMapping = MappingType.Attribute;

				#endregion	PatternId
				#region		LanguageCode

				DataColumn
				dataColumn__Pattern_Language__LanguageCode = dataTable__Pattern_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Pattern_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Pattern_Language__LanguageCode.MaxLength = 3;
				dataColumn__Pattern_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Meaning

				DataColumn
				dataColumn__Pattern_Language__Meaning = dataTable__Pattern_Language.Columns.Add("Meaning", typeof(string));
				dataColumn__Pattern_Language__Meaning.AllowDBNull = true;
				dataColumn__Pattern_Language__Meaning.MaxLength = 512;
				dataColumn__Pattern_Language__Meaning.ColumnMapping = MappingType.Attribute;

				#endregion	Meaning
				#region		PatternUniqueKeyString (Expression)

				DataColumn
				dataColumn__Pattern_Language__PatternUniqueKeyString = dataTable__Pattern_Language.Columns.Add("PatternUniqueKeyString", typeof(string));
				dataColumn__Pattern_Language__PatternUniqueKeyString.ColumnMapping = MappingType.Hidden;

				#endregion	PatternUniqueKeyString (Expression)

				dataTable__Pattern_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__Pattern_Language__PatternId,
					dataColumn__Pattern_Language__LanguageCode
					};

				#region		Pattern_Language__Pattern

				dataSet.Relations.Add
				(
					"Pattern_Language__Pattern",
					new DataColumn[]
					{
					dataColumn__Pattern__Id
					},
					new DataColumn[]
					{
					dataColumn__Pattern_Language__PatternId
					}
				);

				#endregion	Pattern_Language__Pattern
				#region		Pattern_Language__Language

				dataSet.Relations.Add
				(
					"Pattern_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__Pattern_Language__LanguageCode }
				);

				#endregion	Pattern_Language__Language

				/// contrainte d'unicité bi-colonnes				
				dataTable__Pattern_Language
					.Constraints
					.Add
					(
						"UC__Pattern_Laguage__LanguageCode__Meaning", 
						new DataColumn[] 
						{
							dataColumn__Pattern_Language__LanguageCode, 
							dataColumn__Pattern_Language__Meaning
						}, 
						false
					);

				dataColumn__Pattern_Language__PatternUniqueKeyString.Expression = "Parent(Pattern_Language__Pattern).UniqueKeyString";
				
				#endregion	Pattern_Language

				#region		FromPattern (11P)

				DataTable dataTable__FromPattern = dataSet.Tables.Add("FromPattern");

				#region		SubscriberCode

				DataColumn
				dataColumn__FromPattern__SubscriberCode = dataTable__FromPattern.Columns.Add("SubscriberCode");
				dataColumn__FromPattern__SubscriberCode.DataType = typeof(string);
				dataColumn__FromPattern__SubscriberCode.AllowDBNull = false;
				dataColumn__FromPattern__SubscriberCode.MaxLength = 1;
				dataColumn__FromPattern__SubscriberCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscriberCode
				#region		SubscriberId

				DataColumn
				dataColumn__FromPattern__SubscriberId = dataTable__FromPattern.Columns.Add("SubscriberId");
				dataColumn__FromPattern__SubscriberId.DataType = typeof(Int32);
				dataColumn__FromPattern__SubscriberId.AllowDBNull = false;
				dataColumn__FromPattern__SubscriberId.ColumnMapping = MappingType.Attribute;

				#endregion	SubscriberId
				#region		PatternId

				DataColumn
				dataColumn__FromPattern__PatternId = dataTable__FromPattern.Columns.Add("PatternId");
				dataColumn__FromPattern__PatternId.DataType = typeof(Int32);
				dataColumn__FromPattern__PatternId.AllowDBNull = false;
				dataColumn__FromPattern__PatternId.ColumnMapping = MappingType.Attribute;

				#endregion	PatternId
				#region		GuiHorizontalShift

				DataColumn
				dataColumn__WordFromPattern__GuiHorizontalShift = dataTable__FromPattern.Columns.Add("GuiHorizontalShift", typeof(short));
				dataColumn__WordFromPattern__GuiHorizontalShift.AllowDBNull = false;
				dataColumn__WordFromPattern__GuiHorizontalShift.DefaultValue = 0;	///means: no shifting = adjusted to the left-hand side.
				dataColumn__WordFromPattern__GuiHorizontalShift.ColumnMapping = MappingType.Attribute;

				#endregion	GuiHorizontalShift

				dataTable__FromPattern.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__FromPattern__SubscriberCode, 
						dataColumn__FromPattern__SubscriberId
					};

				#region		FromPattern__Pattern

				dataSet.Relations.Add
				(
					"FromPattern__Pattern",
					new DataColumn[] 
					{ 
					dataColumn__Pattern__Id 
					},
					new DataColumn[] 
					{ 
					dataColumn__FromPattern__PatternId 
					}
				);

				#endregion	FromPattern__Pattern

				#endregion	FromPattern (11P)
				#region		FromPatternLetter (1N-Rank)

				DataTable dataTable__FromPatternLetter = dataSet.Tables.Add("FromPatternLetter");

				#region		FromPatternSubscriberCode

				DataColumn
				dataColumn__FromPatternLetter__FromPatternSubscriberCode = dataTable__FromPatternLetter.Columns.Add("FromPatternSubscriberCode");
				dataColumn__FromPatternLetter__FromPatternSubscriberCode.DataType = typeof(string);
				dataColumn__FromPatternLetter__FromPatternSubscriberCode.AllowDBNull = false;
				dataColumn__FromPatternLetter__FromPatternSubscriberCode.MaxLength = 1;
				dataColumn__FromPatternLetter__FromPatternSubscriberCode.ColumnMapping = MappingType.Attribute;

				#endregion	FromPatternSubscriberCode
				#region		FromPatternSubscriberId

				DataColumn
				dataColumn__FromPatternLetter__FromPatternSubscriberId = dataTable__FromPatternLetter.Columns.Add("FromPatternSubscriberId");
				dataColumn__FromPatternLetter__FromPatternSubscriberId.DataType = typeof(Int32);
				dataColumn__FromPatternLetter__FromPatternSubscriberId.AllowDBNull = false;
				dataColumn__FromPatternLetter__FromPatternSubscriberId.ColumnMapping = MappingType.Attribute;

				#endregion	FromPatternSubscriberId
				#region		Rank

				DataColumn 
				dataColumn__FromPatternLetter__Rank = dataTable__FromPatternLetter.Columns.Add("Rank", typeof(short));
				dataColumn__FromPatternLetter__Rank.AllowDBNull = false;
				dataColumn__FromPatternLetter__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank
				#region		LetterTypeCode

				DataColumn
				dataColumn__FromPatternLetter__LetterTypeCode = dataTable__FromPatternLetter.Columns.Add("LetterTypeCode");
				dataColumn__FromPatternLetter__LetterTypeCode.DataType = typeof(string);
				dataColumn__FromPatternLetter__LetterTypeCode.MaxLength = 1;
				dataColumn__FromPatternLetter__LetterTypeCode.AllowDBNull = false;
				dataColumn__FromPatternLetter__LetterTypeCode.ColumnMapping = MappingType.Attribute;

				#endregion	LetterTypeCode
				#region		LetterString

				DataColumn
				dataColumn__FromPatternLetter__LetterString = dataTable__FromPatternLetter.Columns.Add("LetterString");
				dataColumn__FromPatternLetter__LetterString.DataType = typeof(string);
				dataColumn__FromPatternLetter__LetterString.MaxLength = 2;
				dataColumn__FromPatternLetter__LetterString.AllowDBNull = false;
				dataColumn__FromPatternLetter__LetterString.ColumnMapping = MappingType.Attribute;

				#endregion	LetterString

				dataTable__FromPatternLetter.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__FromPatternLetter__FromPatternSubscriberCode, 
						dataColumn__FromPatternLetter__FromPatternSubscriberId,
						dataColumn__FromPatternLetter__Rank
					};

				#region		FromPatternLetter__FromPattern

				dataSet.Relations.Add
				(
					"FromPatternLetter__FromPattern",
					new DataColumn[] 
					{ 
						dataColumn__FromPattern__SubscriberCode, 
						dataColumn__FromPattern__SubscriberId 
					},
					new DataColumn[] 
					{ 
						dataColumn__FromPatternLetter__FromPatternSubscriberCode, 
						dataColumn__FromPatternLetter__FromPatternSubscriberId,
					}
				);

				#endregion	FromPatternLetter__FromPattern
				#region		FromPatternLetter__Letter

				dataSet.Relations.Add
				(
					"FromPatternLetter__Letter",
					new DataColumn[] 
					{ 
						dataColumn__Letter__String, 
						dataColumn__Letter__TypeCode, 
					},
					new DataColumn[] 
					{ 
						dataColumn__FromPatternLetter__LetterString,
						dataColumn__FromPatternLetter__LetterTypeCode
					}
				);

				#endregion	FromPatternLetter__Letter

				#endregion	FromPattern (1N-Rank)

				#region		PatternExNihilo (Mode)

				DataTable dataTable__PatternExNihilo = dataSet.Tables.Add("PatternExNihilo");

				#region		Id

				DataColumn
				dataColumn__PatternExNihilo__Id = dataTable__PatternExNihilo.Columns.Add("Id");
				dataColumn__PatternExNihilo__Id.DataType = typeof(Int32);
				dataColumn__PatternExNihilo__Id.AllowDBNull = false;
				dataColumn__PatternExNihilo__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		SymbolClusterId

				DataColumn
				dataColumn__PatternExNihilo__SymbolClusterId = dataTable__PatternExNihilo.Columns.Add("SymbolClusterId", typeof(int));
				dataColumn__PatternExNihilo__SymbolClusterId.AllowDBNull = false;
				dataColumn__PatternExNihilo__SymbolClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	SymbolClusterId
				#region		ModeCode = "X"

				DataColumn 
				dataColumn__PatternExNihilo__ModeCode = dataTable__PatternExNihilo.Columns.Add("ModeCode", typeof(string));
				dataColumn__PatternExNihilo__ModeCode.AllowDBNull = false;
				dataColumn__PatternExNihilo__ModeCode.MaxLength = 1;
				dataColumn__PatternExNihilo__ModeCode.DefaultValue = "X";
				dataColumn__PatternExNihilo__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode = "X"

				dataTable__PatternExNihilo.PrimaryKey = new DataColumn[] { dataColumn__PatternExNihilo__Id };

				#region		

				dataSet.Relations.Add
				(
					"PatternExNihilo__Pattern",
					new DataColumn[] 
					{ 
						dataColumn__Pattern__Id, 
						dataColumn__Pattern__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternExNihilo__Id, 
						dataColumn__PatternExNihilo__ModeCode 
					}
				);

				#endregion	PatternExNihilo__Pattern
				#region		PatternExNihilo__SymbolCluster

				dataSet.Relations.Add
				(
					"PatternExNihilo__SymbolCluster",
					new DataColumn[] 
					{ 
						dataColumn__SymbolCluster__Id 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternExNihilo__SymbolClusterId 
					}
				);

				#endregion	PatternExNihilo__SymbolCluster

				#endregion	PatternExNihilo (Mode)
				#region		PatternByInsertion (Mode)

				DataTable dataTable__PatternByInsertion = dataSet.Tables.Add("PatternByInsertion");

				#region		Id

				DataColumn
				dataColumn__PatternByInsertion__Id = dataTable__PatternByInsertion.Columns.Add("Id");
				dataColumn__PatternByInsertion__Id.DataType = typeof(Int32);
				dataColumn__PatternByInsertion__Id.AllowDBNull = false;
				dataColumn__PatternByInsertion__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		WordOrPatternSubscriberCode

				DataColumn
				dataColumn__PatternByInsertion__WordOrPatternSubscriberCode = dataTable__PatternByInsertion.Columns.Add("WordOrPatternSubscriberCode", typeof(string));
				dataColumn__PatternByInsertion__WordOrPatternSubscriberCode.AllowDBNull = false;
				dataColumn__PatternByInsertion__WordOrPatternSubscriberCode.MaxLength = 1;
				dataColumn__PatternByInsertion__WordOrPatternSubscriberCode.ColumnMapping = MappingType.Attribute;

				#endregion	WordOrPatternSubscriberCode
				#region		WordOrPatternSubscriberId

				DataColumn
				dataColumn__PatternByInsertion__WordOrPatternSubscriberId = dataTable__PatternByInsertion.Columns.Add("WordOrPatternSubscriberId", typeof(int));
				dataColumn__PatternByInsertion__WordOrPatternSubscriberId.AllowDBNull = false;
				dataColumn__PatternByInsertion__WordOrPatternSubscriberId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterOrSymbolClusterId
				#region		InsertionIndex

				DataColumn
				dataColumn__PatternByInsertion__InsertionIndex = dataTable__PatternByInsertion.Columns.Add("InsertionIndex", typeof(short));
				dataColumn__PatternByInsertion__InsertionIndex.AllowDBNull = false;
				dataColumn__PatternByInsertion__InsertionIndex.DefaultValue = 32;	/// means 'insert it at the end = append it.
				dataColumn__PatternByInsertion__InsertionIndex.ColumnMapping = MappingType.Attribute;

				#endregion	InsertionIndex
				#region		LetterOrSymbolClusterId

				DataColumn
				dataColumn__PatternByInsertion__LetterOrSymbolClusterId = dataTable__PatternByInsertion.Columns.Add("LetterOrSymbolClusterId", typeof(int));
				dataColumn__PatternByInsertion__LetterOrSymbolClusterId.AllowDBNull = false;
				dataColumn__PatternByInsertion__LetterOrSymbolClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterOrSymbolClusterId
				#region		ModeCode = "I"

				DataColumn 
				dataColumn__PatternByInsertion__ModeCode = dataTable__PatternByInsertion.Columns.Add("ModeCode", typeof(string));
				dataColumn__PatternByInsertion__ModeCode.AllowDBNull = false;
				dataColumn__PatternByInsertion__ModeCode.MaxLength = 1;
				dataColumn__PatternByInsertion__ModeCode.DefaultValue = "I";
				dataColumn__PatternByInsertion__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode = "I"

				dataTable__PatternByInsertion.PrimaryKey = new DataColumn[] { dataColumn__PatternByInsertion__Id };

				#region		

				dataSet.Relations.Add
				(
					"PatternByInsertion__Pattern",
					new DataColumn[] 
					{ 
						dataColumn__Pattern__Id, 
						dataColumn__Pattern__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternByInsertion__Id, 
						dataColumn__PatternByInsertion__ModeCode 
					}
				);

				#endregion	PatternByInsertion__Pattern
				#region		PatternByInsertion__WordOrPattern

				dataSet.Relations.Add
				(
					"PatternByInsertion__WordOrPattern",
					new DataColumn[] 
					{ 
						dataColumn__WordOrPattern__SubscriberCode, 
						dataColumn__WordOrPattern__SubscriberId 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternByInsertion__WordOrPatternSubscriberCode,
						dataColumn__PatternByInsertion__WordOrPatternSubscriberId
					}
				);

				#endregion	PatternByInsertion__WordOrPattern
				#region		PatternByInsertion__LetterOrSymbolCluster

				dataSet.Relations.Add
				(
					"PatternByInsertion__LetterOrSymbolCluster",
					new DataColumn[] 
					{ 
						dataColumn__LetterOrSymbolCluster__Id 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternByInsertion__LetterOrSymbolClusterId 
					}
				);

				#endregion	PatternByInsertion__LetterOrSymbolCluster

				#endregion	PatternByInsertion (Mode)
				#region		PatternFromPattern (Mode)

				DataTable dataTable__PatternFromPattern = dataSet.Tables.Add("PatternFromPattern");

				#region		Id

				DataColumn
				dataColumn__PatternFromPattern__Id = dataTable__PatternFromPattern.Columns.Add("Id");
				dataColumn__PatternFromPattern__Id.DataType = typeof(Int32);
				dataColumn__PatternFromPattern__Id.AllowDBNull = false;
				dataColumn__PatternFromPattern__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		ModeCode = "P"

				DataColumn 
				dataColumn__PatternFromPattern__ModeCode = dataTable__PatternFromPattern.Columns.Add("ModeCode", typeof(string));
				dataColumn__PatternFromPattern__ModeCode.AllowDBNull = false;
				dataColumn__PatternFromPattern__ModeCode.MaxLength = 1;
				dataColumn__PatternFromPattern__ModeCode.DefaultValue = "P";
				dataColumn__PatternFromPattern__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode = "P"
				#region		SubscribingCode

				DataColumn
				dataColumn__PatternFromPattern__SubscribingCode = dataTable__PatternFromPattern.Columns.Add("SubscribingCode", typeof(string));
				dataColumn__PatternFromPattern__SubscribingCode.AllowDBNull = false;
				dataColumn__PatternFromPattern__SubscribingCode.MaxLength = 1;
				dataColumn__PatternFromPattern__SubscribingCode.DefaultValue = "P";
				dataColumn__PatternFromPattern__SubscribingCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscribingCode

				dataTable__PatternFromPattern.PrimaryKey = new DataColumn[] { dataColumn__PatternFromPattern__Id };

				#region		PatternFromPattern__Pattern

				dataSet.Relations.Add
				(
					"PatternFromPattern__Pattern",
					new DataColumn[] 
					{ 
						dataColumn__Pattern__Id, 
						dataColumn__Pattern__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternFromPattern__Id, 
						dataColumn__PatternFromPattern__ModeCode 
					}
				);

				#endregion	PatternFromPattern__Pattern
				#region		PatternFromPattern__FromPattern

				dataSet.Relations.Add
				(
					"PatternFromPattern__FromPattern",
					new DataColumn[] 
					{ 
						dataColumn__FromPattern__SubscriberCode, 
						dataColumn__FromPattern__SubscriberId 
					},
					new DataColumn[] 
					{ 
						dataColumn__PatternFromPattern__SubscribingCode,
						dataColumn__PatternFromPattern__Id
					}
				);

				#endregion	PatternFromPattern__FromPattern

				#endregion	PatternFromPattern (Mode)


				#region		Word

				DataTable dataTable__Word = dataSet.Tables.Add("Word");

				#region		Id

				DataColumn
				dataColumn__Word__Id = dataTable__Word.Columns.Add("Id", typeof(Int32));
				dataColumn__Word__Id.AllowDBNull = false;
				dataColumn__Word__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		UniqueKeyString

				DataColumn
				dataColumn__Word__UniqueKeyString = dataTable__Word.Columns.Add("UniqueKeyString", typeof(string));
				dataColumn__Word__UniqueKeyString.AllowDBNull = false;
				dataColumn__Word__UniqueKeyString.MaxLength = 32;
				dataColumn__Word__UniqueKeyString.ColumnMapping = MappingType.Attribute;
				dataColumn__Word__UniqueKeyString.Unique = true;

				#endregion	UniqueKeyString
				#region		WordTypeId

				DataColumn
				dataColumn__Word__WordTypeId = dataTable__Word.Columns.Add("WordTypeId", typeof(short));
				dataColumn__Word__WordTypeId.AllowDBNull = false;
				dataColumn__Word__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		ModeCode

				/// Modes :
				/// S = FromPattern
				/// I = ByInsertion
				/// D = Derivated
				/// C = Concatenated

				DataColumn
				dataColumn__Word__ModeCode = dataTable__Word.Columns.Add("ModeCode", typeof(string));
				dataColumn__Word__ModeCode.AllowDBNull = true;
				dataColumn__Word__ModeCode.MaxLength = 1;
				dataColumn__Word__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		HasDerivating

				DataColumn
				dataColumn__Word__HasDerivating = dataTable__Word.Columns.Add("HasDerivating", typeof(bool));
				dataColumn__Word__HasDerivating.AllowDBNull = false;
				dataColumn__Word__HasDerivating.DefaultValue = false;
				dataColumn__Word__HasDerivating.ColumnMapping = MappingType.Attribute;

				#endregion	HasDerivating
				#region		SubscribingCode

				DataColumn
				dataColumn__Word__SubscribingCode = dataTable__Word.Columns.Add("SubscribingCode", typeof(string));
				dataColumn__Word__SubscribingCode.AllowDBNull = false;
				dataColumn__Word__SubscribingCode.DefaultValue = "W";
				dataColumn__Word__SubscribingCode.MaxLength = 1;
				dataColumn__Word__SubscribingCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscribingCode

				dataTable__Word.PrimaryKey = new DataColumn[] { dataColumn__Word__Id };

				#region		Word_WordOrPattern

				dataSet.Relations.Add
				(
					"Word_WordOrPattern",
					new DataColumn[] { dataColumn__WordOrPattern__SubscriberCode, dataColumn__WordOrPattern__SubscriberId },
					new DataColumn[] { dataColumn__Word__SubscribingCode, dataColumn__Word__Id }
				);

				#endregion	Word_WordOrPattern
				#region		Word_WordType

				dataSet.Relations.Add
				(
					"Word_WordType",
					new DataColumn[] { dataColumn__WordType__Id },
					new DataColumn[] { dataColumn__Word__WordTypeId }
				);

				#endregion	Word_WordType

				#endregion	Word
				#region		Word_Language

				DataTable dataTable__Word_Language = dataSet.Tables.Add("Word_Language");

				#region		WordId

				DataColumn
				dataColumn__Word_Language__WordId = dataTable__Word_Language.Columns.Add("WordId", typeof(Int32));
				dataColumn__Word_Language__WordId.AllowDBNull = false;
				dataColumn__Word_Language__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId
				#region		LanguageCode

				DataColumn
				dataColumn__Word_Language__LanguageCode = dataTable__Word_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Word_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Word_Language__LanguageCode.MaxLength = 3;
				dataColumn__Word_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		WordTypeId

				DataColumn
				dataColumn__Word_Language__WordTypeId = dataTable__Word_Language.Columns.Add("WordTypeId", typeof(short));
				dataColumn__Word_Language__WordTypeId.AllowDBNull = false;
				dataColumn__Word_Language__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		Meaning

				DataColumn
				dataColumn__Word_Language__Meaning = dataTable__Word_Language.Columns.Add("Meaning", typeof(string));
				dataColumn__Word_Language__Meaning.AllowDBNull = true;
				dataColumn__Word_Language__Meaning.MaxLength = 512;
				dataColumn__Word_Language__Meaning.ColumnMapping = MappingType.Attribute;

				#endregion	Meaning
				#region		WordUniqueKeyString (Expression)

				DataColumn
				dataColumn__Word_Language__WordUniqueKeyString = dataTable__Word_Language.Columns.Add("WordUniqueKeyString", typeof(string));
				dataColumn__Word_Language__WordUniqueKeyString.ColumnMapping = MappingType.Hidden;

				#endregion	WordUniqueKeyString (Expression)
				#region		WordHasDerivating (Expression)

				DataColumn
				dataColumn__Word_Language__WordHasDerivating = dataTable__Word_Language.Columns.Add("WordHasDerivating", typeof(bool));
				dataColumn__Word_Language__WordHasDerivating.ColumnMapping = MappingType.Hidden;

				#endregion	HasDerivating (Expression)

				dataTable__Word_Language.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__Word_Language__WordId,
					dataColumn__Word_Language__LanguageCode
					};

				#region		Word_Language__Word

				dataSet.Relations.Add
				(
					"Word_Language__Word",
					new DataColumn[]
					{
					dataColumn__Word__Id,
					dataColumn__Word__WordTypeId
					},
					new DataColumn[]
					{
					dataColumn__Word_Language__WordId,
					dataColumn__Word_Language__WordTypeId
					}
				);

				#endregion	Word_Language__Word
				#region		Word_Language__Language

				dataSet.Relations.Add
				(
					"Word_Language__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__Word_Language__LanguageCode }
				);

				#endregion	Word_Language__Language
				#region		Word_Language__WordType_Language

				dataSet.Relations.Add
				(
					"Word_Language__WordType_Language",
					new DataColumn[]
					{
					dataColumn__WordType_Language__WordTypeId,
					dataColumn__WordType_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__Word_Language__WordTypeId,
					dataColumn__Word_Language__LanguageCode
					}
				);

				#endregion	Word_Language__WordType_Language

				dataColumn__Word_Language__WordUniqueKeyString	.Expression = "Parent(Word_Language__Word).UniqueKeyString";
				dataColumn__Word_Language__WordHasDerivating	.Expression = "Parent(Word_Language__Word).HasDerivating";

				#endregion	Word_Language
				#region		LanguageWord

				DataTable dataTable__LanguageWord = dataSet.Tables.Add("LanguageWord");

				#region		LanguageCode

				DataColumn
				dataColumn__LanguageWord__LanguageCode = dataTable__LanguageWord.Columns.Add("LanguageCode", typeof(string));
				dataColumn__LanguageWord__LanguageCode.AllowDBNull = false;
				dataColumn__LanguageWord__LanguageCode.MaxLength = 3;
				dataColumn__LanguageWord__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		String

				DataColumn
				dataColumn__LanguageWord__String = dataTable__LanguageWord.Columns.Add("String", typeof(string));
				dataColumn__LanguageWord__String.AllowDBNull = false;
				dataColumn__LanguageWord__String.MaxLength = 32;
				dataColumn__LanguageWord__String.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__LanguageWord.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__LanguageWord__LanguageCode,
					dataColumn__LanguageWord__String
					};

				#region		LanguageWord__Language

				dataSet.Relations.Add
				(
					"LanguageWord__Language",
					new DataColumn[] { dataColumn__Language__Code },
					new DataColumn[] { dataColumn__LanguageWord__LanguageCode }
				);

				#endregion	LanguageWord__Language

				#endregion	LanguageWord
				#region		Word_LanguageWord

				DataTable dataTable__Word_LanguageWord = dataSet.Tables.Add("Word_LanguageWord");

				#region		WordId

				DataColumn
				dataColumn__Word_LanguageWord__WordId = dataTable__Word_LanguageWord.Columns.Add("WordId", typeof(Int32));
				dataColumn__Word_LanguageWord__WordId.AllowDBNull = false;
				dataColumn__Word_LanguageWord__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId
				#region		LanguageCode

				DataColumn
				dataColumn__Word_LanguageWord__LanguageCode = dataTable__Word_LanguageWord.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Word_LanguageWord__LanguageCode.AllowDBNull = false;
				dataColumn__Word_LanguageWord__LanguageCode.MaxLength = 3;
				dataColumn__Word_LanguageWord__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		LanguageWordString

				DataColumn
				dataColumn__Word_LanguageWord__LanguageWordString = dataTable__Word_LanguageWord.Columns.Add("LanguageWordString", typeof(string));
				dataColumn__Word_LanguageWord__LanguageWordString.AllowDBNull = false;
				dataColumn__Word_LanguageWord__LanguageWordString.MaxLength = 32;
				dataColumn__Word_LanguageWord__LanguageWordString.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageWordString
				#region		WordUniqueKeyString

				DataColumn 
				dataColumn__Word_LanguageWord__WordUniqueKeyString = dataTable__Word_LanguageWord.Columns.Add("WordUniqueKeyString", typeof(string));
				dataColumn__Word_LanguageWord__WordUniqueKeyString.ColumnMapping = MappingType.Hidden;

				#endregion	WordUniqueKeyString
				#region		Word_LanguageMeaning

				DataColumn 
				dataColumn__Word_LanguageWord__Word_LanguageMeaning = dataTable__Word_LanguageWord.Columns.Add("Word_LanguageMeaning", typeof(string));
				dataColumn__Word_LanguageWord__Word_LanguageMeaning.ColumnMapping = MappingType.Hidden;

				#endregion	Word_LanguageMeaning		

				dataTable__Word_LanguageWord.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__Word_LanguageWord__WordId,
					dataColumn__Word_LanguageWord__LanguageCode,
					dataColumn__Word_LanguageWord__LanguageWordString
					};

				#region		Word_LanguageWord__Word_Language

				dataSet.Relations.Add
				(
					"Word_LanguageWord__Word_Language",
					new DataColumn[]
					{
					dataColumn__Word_Language__WordId,
					dataColumn__Word_Language__LanguageCode
					},
					new DataColumn[]
					{
					dataColumn__Word_LanguageWord__WordId,
					dataColumn__Word_LanguageWord__LanguageCode
					}
				);

				#endregion	Word_LanguageWord__Word_Language
				#region		Word_LanguageWord__LanguageWord

				dataSet.Relations.Add
				(
					"Word_LanguageWord__LanguageWord",
					new DataColumn[]
					{
					dataColumn__LanguageWord__LanguageCode,
					dataColumn__LanguageWord__String
					},
					new DataColumn[]
					{
					dataColumn__Word_LanguageWord__LanguageCode,
					dataColumn__Word_LanguageWord__LanguageWordString
					}
				);

				#endregion	Word_LanguageWord__LanguageWord

				dataColumn__Word_LanguageWord__WordUniqueKeyString.Expression	= "Parent(Word_LanguageWord__Word_Language).WordUniqueKeyString";
				dataColumn__Word_LanguageWord__Word_LanguageMeaning.Expression	= "Parent(Word_LanguageWord__Word_Language).Meaning";

				#endregion	Word_LanguageWord

				#region		WordFromPattern (Mode)

				DataTable dataTable__WordFromPattern = dataSet.Tables.Add("WordFromPattern");

				#region		Id

				DataColumn
				dataColumn__WordFromPattern__Id = dataTable__WordFromPattern.Columns.Add("Id", typeof(Int32));
				dataColumn__WordFromPattern__Id.AllowDBNull = false;
				dataColumn__WordFromPattern__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		ModeCode
				DataColumn
				dataColumn__WordFromPattern__ModeCode = dataTable__WordFromPattern.Columns.Add("ModeCode", typeof(string));
				dataColumn__WordFromPattern__ModeCode.AllowDBNull = true;
				dataColumn__WordFromPattern__ModeCode.MaxLength = 1;
				dataColumn__WordFromPattern__ModeCode.DefaultValue = "P";
				dataColumn__WordFromPattern__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		SubscribingCode

				DataColumn
				dataColumn__WordFromPattern__SubscribingCode = dataTable__WordFromPattern.Columns.Add("SubscribingCode", typeof(string));
				dataColumn__WordFromPattern__SubscribingCode.AllowDBNull = false;
				dataColumn__WordFromPattern__SubscribingCode.MaxLength = 1;
				dataColumn__WordFromPattern__SubscribingCode.DefaultValue = "W";
				dataColumn__WordFromPattern__SubscribingCode.ColumnMapping = MappingType.Attribute;

				#endregion	SubscribingCode

				dataTable__WordFromPattern.PrimaryKey = new DataColumn[] { dataColumn__WordFromPattern__Id };

				#region		WordFromPattern__Word

				dataSet.Relations.Add
				(
					"WordFromPattern__Word",
					new DataColumn[] 
					{ 
						dataColumn__Word__Id, 
						dataColumn__Word__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__WordFromPattern__Id, 
						dataColumn__WordFromPattern__ModeCode 
					}
				);

				#endregion	WordFromPattern__Word
				#region		WordFromPattern__FromPattern

				dataSet.Relations.Add
				(
					"WordFromPattern__FromPattern",
					new DataColumn[] 
					{ 
						dataColumn__FromPattern__SubscriberCode, 
						dataColumn__FromPattern__SubscriberId 
					},
					new DataColumn[] 
					{ 
						dataColumn__WordFromPattern__SubscribingCode,
						dataColumn__WordFromPattern__Id
					}
				);

				#endregion	WordFromPattern__FromPattern

				#endregion	WordFromPattern (Mode)
				#region		WordByInsertion (Mode)

				DataTable dataTable__WordByInsertion = dataSet.Tables.Add("WordByInsertion");

				#region		Id

				DataColumn
				dataColumn__WordByInsertion__Id = dataTable__WordByInsertion.Columns.Add("Id");
				dataColumn__WordByInsertion__Id.DataType = typeof(Int32);
				dataColumn__WordByInsertion__Id.AllowDBNull = false;
				dataColumn__WordByInsertion__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		OriginWordId

				DataColumn
				dataColumn__WordByInsertion__OriginWordId = dataTable__WordByInsertion.Columns.Add("OriginWordId", typeof(int));
				dataColumn__WordByInsertion__OriginWordId.AllowDBNull = false;
				dataColumn__WordByInsertion__OriginWordId.ColumnMapping = MappingType.Attribute;

				#endregion	OriginWordId
				#region		InsertionIndex

				DataColumn
				dataColumn__WordByInsertion__InsertionIndex = dataTable__WordByInsertion.Columns.Add("InsertionIndex", typeof(short));
				dataColumn__WordByInsertion__InsertionIndex.AllowDBNull = false;
				dataColumn__WordByInsertion__InsertionIndex.DefaultValue = 32;	/// means 'insert it at the end = append it.
				dataColumn__WordByInsertion__InsertionIndex.ColumnMapping = MappingType.Attribute;

				#endregion	InsertionIndex
				#region		LetterClusterId

				DataColumn
				dataColumn__WordByInsertion__LetterClusterId = dataTable__WordByInsertion.Columns.Add("LetterClusterId", typeof(int));
				dataColumn__WordByInsertion__LetterClusterId.AllowDBNull = false;
				dataColumn__WordByInsertion__LetterClusterId.ColumnMapping = MappingType.Attribute;

				#endregion	LetterClusterId
				#region		ModeCode = "I"

				DataColumn 
				dataColumn__WordByInsertion__ModeCode = dataTable__WordByInsertion.Columns.Add("ModeCode", typeof(string));
				dataColumn__WordByInsertion__ModeCode.AllowDBNull = false;
				dataColumn__WordByInsertion__ModeCode.MaxLength = 1;
				dataColumn__WordByInsertion__ModeCode.DefaultValue = "I";
				dataColumn__WordByInsertion__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode = "I"

				dataTable__WordByInsertion.PrimaryKey = new DataColumn[] { dataColumn__WordByInsertion__Id };

				#region		WordByInsertion__Word

				dataSet.Relations.Add
				(
					"WordByInsertion__Word",
					new DataColumn[] 
					{ 
						dataColumn__Word__Id, 
						dataColumn__Word__ModeCode 
					},
					new DataColumn[] 
					{ 
						dataColumn__WordByInsertion__Id, 
						dataColumn__WordByInsertion__ModeCode 
					}
				);

				#endregion	WordByInsertion__Word
				#region		WordByInsertion__Word__Origin

				dataSet.Relations.Add
				(
					"WordByInsertion__Word__Origin",
					new DataColumn[] 
					{ 
						dataColumn__Word__Id 
					},
					new DataColumn[] 
					{ 
						dataColumn__WordByInsertion__OriginWordId
					}
				);

				#endregion	WordByInsertion__Word__Origin
				#region		WordByInsertion__LetterCluster

				dataSet.Relations.Add
				(
					"WordByInsertion__LetterCluster",
					new DataColumn[] 
					{ 
						dataColumn__LetterCluster__Id 
					},
					new DataColumn[] 
					{ 
						dataColumn__WordByInsertion__LetterClusterId 
					}
				);

				#endregion	WordByInsertion__LetterOrSymbolCluster

				#endregion	WordByInsertion (Mode)

				#region		WordConcatenated (Mode)

				DataTable dataTable__WordConcatenated = dataSet.Tables.Add("WordConcatenated");

				#region		Id

				DataColumn
				dataColumn__WordConcatenated__Id = dataTable__WordConcatenated.Columns.Add("Id", typeof(Int32));
				dataColumn__WordConcatenated__Id.AllowDBNull = false;
				dataColumn__WordConcatenated__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		ModeCode

				DataColumn
				dataColumn__WordConcatenated__ModeCode = dataTable__WordConcatenated.Columns.Add("ModeCode", typeof(string));
				dataColumn__WordConcatenated__ModeCode.AllowDBNull = false;
				dataColumn__WordConcatenated__ModeCode.MaxLength = 1;
				dataColumn__WordConcatenated__ModeCode.DefaultValue = "C";
				dataColumn__WordConcatenated__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode

				dataTable__WordConcatenated.PrimaryKey = new DataColumn[] { dataColumn__WordConcatenated__Id };

				#region		WordConcatenated__Word

				dataSet.Relations.Add
				(
					"WordConcatenated__Word",
					new DataColumn[]
					{
					dataColumn__Word__Id,
					dataColumn__Word__ModeCode
					},
					new DataColumn[]
					{
					dataColumn__WordConcatenated__Id,
					dataColumn__WordConcatenated__ModeCode
					}
				);

				#endregion	WordConcatenated__Word

				#endregion	WordConcatenated (Mode)
				#region		WordConcatenatedComponent

				DataTable dataTable__WordConcatenatedComponent = dataSet.Tables.Add("WordConcatenatedComponent");

				#region		WordConcatenatedId

				DataColumn
				dataColumn__WordConcatenatedComponent__WordConcatenatedId = dataTable__WordConcatenatedComponent.Columns.Add("WordConcatenatedId", typeof(Int32));
				dataColumn__WordConcatenatedComponent__WordConcatenatedId.AllowDBNull = false;
				dataColumn__WordConcatenatedComponent__WordConcatenatedId.ColumnMapping = MappingType.Attribute;

				#endregion	WordConcatenatedId
				#region		Rank

				DataColumn
				dataColumn__WordConcatenatedComponent__Rank = dataTable__WordConcatenatedComponent.Columns.Add("Rank", typeof(short));
				dataColumn__WordConcatenatedComponent__Rank.AllowDBNull = false;
				dataColumn__WordConcatenatedComponent__Rank.ColumnMapping = MappingType.Attribute;

				#endregion	Rank
				#region		WordId

				DataColumn
				dataColumn__WordConcatenated__WordId = dataTable__WordConcatenatedComponent.Columns.Add("WordId", typeof(Int32));
				dataColumn__WordConcatenated__WordId.AllowDBNull = false;
				dataColumn__WordConcatenated__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId
				#region		SubStringIndex

				DataColumn
				dataColumn__WordConcatenatedComponent__SubStringIndex = dataTable__WordConcatenatedComponent.Columns.Add("SubStringIndex", typeof(short));
				dataColumn__WordConcatenatedComponent__SubStringIndex.AllowDBNull = true;
				dataColumn__WordConcatenatedComponent__SubStringIndex.ColumnMapping = MappingType.Attribute;

				#endregion	SubStringIndex
				#region		SubStringLength

				DataColumn
				dataColumn__WordConcatenatedComponent__SubStringLength = dataTable__WordConcatenatedComponent.Columns.Add("SubStringLength", typeof(short));
				dataColumn__WordConcatenatedComponent__SubStringLength.AllowDBNull = true;
				dataColumn__WordConcatenatedComponent__SubStringLength.ColumnMapping = MappingType.Attribute;

				#endregion	SubStringLength

				dataTable__WordConcatenatedComponent.PrimaryKey
					= new DataColumn[]
					{
					dataColumn__WordConcatenatedComponent__WordConcatenatedId,
					dataColumn__WordConcatenatedComponent__Rank
					};

				#region		WordConcatenatedComponent__WordConcatenated

				dataSet.Relations.Add
				(
					"WordConcatenatedComponent__WordConcatenated",
					new DataColumn[]
					{
					dataColumn__WordConcatenated__Id
					},
					new DataColumn[]
					{
					dataColumn__WordConcatenatedComponent__WordConcatenatedId
					}
				);

				#endregion	WordConcatenatedComponent__WordConcatenated
				#region		WordConcatenatedComponent__Word

				dataSet.Relations.Add
				(
					"WordConcatenatedComponent__Word",
					new DataColumn[]
					{
					dataColumn__Word__Id
					},
					new DataColumn[]
					{
					dataColumn__WordConcatenated__WordId
					}
				);

				#endregion	WordConcatenatedComponent__Word

				#endregion	WordConcatenatedComponent

				#region		WordDerivating (optional 11C => WordId instead of Id only)

				DataTable dataTable__WordDerivating = dataSet.Tables.Add("WordDerivating");

				#region		WordId

				DataColumn
				dataColumn__WordDerivating__WordId = dataTable__WordDerivating.Columns.Add("WordId", typeof(Int32));
				dataColumn__WordDerivating__WordId.AllowDBNull = false;
				dataColumn__WordDerivating__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId
				#region		WordTypeId

				DataColumn
				dataColumn__WordDerivating__WordTypeId = dataTable__WordDerivating.Columns.Add("WordTypeId", typeof(short));
				dataColumn__WordDerivating__WordTypeId.AllowDBNull = false;
				dataColumn__WordDerivating__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__WordDerivating__DerivatingWordTypeId = dataTable__WordDerivating.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__WordDerivating__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__WordDerivating__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingWordTypeId
				#region		WordUniqueKeyString (Expression)

				DataColumn
				dataColumn__WordDerivating__WordUniqueKeyString = dataTable__WordDerivating.Columns.Add("WordUniqueKeyString", typeof(string));
				dataColumn__WordDerivating__WordUniqueKeyString.ColumnMapping = MappingType.Hidden;

				#endregion	WordUniqueKeyString (Expression)

				dataTable__WordDerivating.PrimaryKey = new DataColumn[] { dataColumn__WordDerivating__WordId };

				#region		WordDerivating__Word

				dataSet.Relations.Add
				(
					"WordDerivating__Word",
					new DataColumn[]
					{
					dataColumn__Word__Id,
					dataColumn__Word__WordTypeId
					},
					new DataColumn[]
					{
					dataColumn__WordDerivating__WordId,
					dataColumn__WordDerivating__WordTypeId
					}
				);

				#endregion	WordDerivating__Word
				#region		WordDerivating__DerivatingWordType

				dataSet.Relations.Add
				(
					"WordDerivating__DerivatingWordType",
					new DataColumn[]
					{
					dataColumn__DerivatingWordType__Id,
					dataColumn__DerivatingWordType__WordTypeId
					},
					new DataColumn[]
					{
					dataColumn__WordDerivating__DerivatingWordTypeId,
					dataColumn__WordDerivating__WordTypeId
					}
				);

				#endregion	WordDerivating__DerivatingWordType

				dataColumn__WordDerivating__WordUniqueKeyString.Expression = "Parent(WordDerivating__Word).UniqueKeyString"; 

				#endregion	WordDerivating (11C)
				#region		WordDerivated (Mode)

				DataTable dataTable__WordDerivated = dataSet.Tables.Add("WordDerivated");

				#region		Id

				DataColumn
				dataColumn__WordDerivated__Id = dataTable__WordDerivated.Columns.Add("Id", typeof(Int32));
				dataColumn__WordDerivated__Id.AllowDBNull = false;
				dataColumn__WordDerivated__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		ModeCode

				DataColumn
				dataColumn__WordDerivated__ModeCode = dataTable__WordDerivated.Columns.Add("ModeCode", typeof(string));
				dataColumn__WordDerivated__ModeCode.AllowDBNull = false;
				dataColumn__WordDerivated__ModeCode.MaxLength = 1;
				dataColumn__WordDerivated__ModeCode.DefaultValue = "D";
				dataColumn__WordDerivated__ModeCode.ColumnMapping = MappingType.Attribute;

				#endregion	ModeCode
				#region		WordTypeId

				DataColumn
				dataColumn__WordDerivated__WordTypeId = dataTable__WordDerivated.Columns.Add("WordTypeId", typeof(short));
				dataColumn__WordDerivated__WordTypeId.AllowDBNull = false;
				dataColumn__WordDerivated__WordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	WordTypeId
				#region		DerivatedWordTypeId

				DataColumn
				dataColumn__WordDerivated__DerivatedWordTypeId = dataTable__WordDerivated.Columns.Add("DerivatedWordTypeId", typeof(short));
				dataColumn__WordDerivated__DerivatedWordTypeId.AllowDBNull = false;
				dataColumn__WordDerivated__DerivatedWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId
				#region		WordDerivatingId

				DataColumn
				dataColumn__WordDerivated__WordDerivatingId = dataTable__WordDerivated.Columns.Add("WordDerivatingId", typeof(Int32));
				dataColumn__WordDerivated__WordDerivatingId.AllowDBNull = false;
				dataColumn__WordDerivated__WordDerivatingId.ColumnMapping = MappingType.Attribute;

				#endregion	WordDerivatingId
				#region		DerivatingWordTypeId

				DataColumn
				dataColumn__WordDerivated__DerivatingWordTypeId = dataTable__WordDerivated.Columns.Add("DerivatingWordTypeId", typeof(short));
				dataColumn__WordDerivated__DerivatingWordTypeId.AllowDBNull = false;
				dataColumn__WordDerivated__DerivatingWordTypeId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatedWordTypeId
				#region		DerivatingId

				DataColumn
				dataColumn__WordDerivated__DerivatingId = dataTable__WordDerivated.Columns.Add("DerivatingId", typeof(short));
				dataColumn__WordDerivated__DerivatingId.AllowDBNull = false;
				dataColumn__WordDerivated__DerivatingId.ColumnMapping = MappingType.Attribute;

				#endregion	DerivatingId

				dataTable__WordDerivated.PrimaryKey = new DataColumn[] { dataColumn__WordDerivated__Id };

				#region		WordDerivated__Word

				dataSet.Relations.Add
				(
					"WordDerivated__Word",
					new DataColumn[]
					{
					dataColumn__Word__Id,
					dataColumn__Word__ModeCode,
					dataColumn__Word__WordTypeId
					},
					new DataColumn[]
					{
					dataColumn__WordDerivated__Id,
					dataColumn__WordDerivated__ModeCode,			/// contrainte de Mode = "D"
					dataColumn__WordDerivated__WordTypeId           /// Contrainte de (Derivated) WordType (in)
					}
				);

				#endregion	WordDerivated__Word
				#region		WordDerivated__DerivatedWordType

				dataSet.Relations.Add
				(
					"WordDerivated__DerivatedWordType",
					new DataColumn[]
					{
					dataColumn__DerivatedWordType__Id,
					dataColumn__DerivatedWordType__WordTypeId
					},
					new DataColumn[]
					{
					dataColumn__WordDerivated__DerivatedWordTypeId,	/// Contrainte de DerivatedWordType (in)
					dataColumn__WordDerivated__WordTypeId           /// Contrainte de (Derivated) WordType (out)
					}
				);

				#endregion	WordDerivated__DerivatedWordType
				#region		WordDerivated__WordDerivating

				dataSet.Relations.Add
				(
					"WordDerivated__WordDerivating",
					new DataColumn[]
					{
					dataColumn__WordDerivating__WordId,
					dataColumn__WordDerivating__DerivatingWordTypeId
					},
					new DataColumn[]
					{
					dataColumn__WordDerivated__WordDerivatingId,	/// Contrainte de DerivatingWordType (in)
					dataColumn__WordDerivated__DerivatingWordTypeId
					}
				);

				#endregion	WordDerivated__WordDerivating
				#region		WordDerivated__WordDerivatingType_WordDerivatedType

				dataSet.Relations.Add
				(
					"WordDerivated__WordDerivatingType_WordDerivatedType",
					new DataColumn[]
					{
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId,	/// Contrainte de DerivatingWordType (out-in)
					dataColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId   /// Contrainte de DerivatedWordType (out-in)
					},
					new DataColumn[]
					{
					dataColumn__WordDerivated__DerivatingWordTypeId,
					dataColumn__WordDerivated__DerivatedWordTypeId
					}
				);

				#endregion	WordDerivated__WordDerivatingType_WordDerivatedType
				#region		WordDerivated__Derivating

				dataSet.Relations.Add
				(
					"WordDerivated__Derivating",
					new DataColumn[]
					{
					dataColumn__Derivating__Id,
					dataColumn__Derivating__DerivatingWordTypeId,	/// Contrainte de DerivatingWordType (out-in-out)
					dataColumn__Derivating__DerivatedWordTypeId     /// Contrainte de DerivatedWordType (out-in-out)
					},
					new DataColumn[]
					{
					dataColumn__WordDerivated__DerivatingId,
					dataColumn__WordDerivated__DerivatingWordTypeId,	/// Contrainte de DerivatingWordType (out-in-out)
					dataColumn__WordDerivated__DerivatedWordTypeId      /// Contrainte de DerivatedWordType (out-in-out)
					}
				);

				#endregion	WordDerivated__Derivating

				#endregion	WordDerivated (Mode)

				#region		Author

				DataTable dataTable__Author = dataSet.Tables.Add("Author");

				#region		Id

				DataColumn
				dataColumn__Author__Id = dataTable__Author.Columns.Add("Id", typeof(Int32));
				dataColumn__Author__Id.AllowDBNull = false;
				dataColumn__Author__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		Name

				DataColumn
				dataColumn__Book__Name = dataTable__Author.Columns.Add("Name", typeof(string));
				dataColumn__Book__Name.AllowDBNull = false;
				dataColumn__Book__Name.MaxLength = 64;
				dataColumn__Book__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name

				dataTable__Author.PrimaryKey = new DataColumn[] { dataColumn__Author__Id };

				#endregion	Author
				#region		Author_Language

				DataTable dataTable__Author_Language = dataSet.Tables.Add("Author_Language");

				#region		AuthorId

				DataColumn
				dataColumn__Author_Language__AuthorId = dataTable__Author_Language.Columns.Add("AuthorId", typeof(Int32));
				dataColumn__Author_Language__AuthorId.AllowDBNull = false;
				dataColumn__Author_Language__AuthorId.ColumnMapping = MappingType.Attribute;

				#endregion	AuthorId
				#region		LanguageCode

				DataColumn
				dataColumn__Author_Language__LanguageCode = dataTable__Author_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Author_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Author_Language__LanguageCode.MaxLength = 3;
				dataColumn__Author_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Name

				DataColumn
				dataColumn__Book__Language__Name = dataTable__Author_Language.Columns.Add("Name", typeof(string));
				dataColumn__Book__Language__Name.AllowDBNull = false;
				dataColumn__Book__Language__Name.MaxLength = 64;
				dataColumn__Book__Language__Name.ColumnMapping = MappingType.Attribute;

				#endregion	Name

				dataTable__Author_Language.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__Author_Language__AuthorId,
						dataColumn__Author_Language__LanguageCode
					};

				#region		Author_Language__Author

				dataSet.Relations.Add
				(
					"Author_Language__Author",
					new DataColumn[]
					{
						dataColumn__Author__Id
					},
					new DataColumn[]
					{
						dataColumn__Author_Language__AuthorId
					}
				);

				#endregion	Author_Language__Author
				#region		Author_Language__Language

				dataSet.Relations.Add
				(
					"Author_Language__Language",
					new DataColumn[]
					{
						dataColumn__Language__Code
					},
					new DataColumn[]
					{
						dataColumn__Author_Language__LanguageCode
					}
				);

				#endregion	Author_Language__Language

				#endregion	Author_Language

				#region		Book

				DataTable dataTable__Book = dataSet.Tables.Add("Book");

				#region		Id

				DataColumn
				dataColumn__Book__Id = dataTable__Book.Columns.Add("Id", typeof(Int32));
				dataColumn__Book__Id.AllowDBNull = false;
				dataColumn__Book__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		ISBN

				DataColumn
				dataColumn__Book__ISBN = dataTable__Book.Columns.Add("ISBN", typeof(string));
				dataColumn__Book__ISBN.AllowDBNull = false;
				dataColumn__Book__ISBN.MaxLength = 13;
				dataColumn__Book__ISBN.ColumnMapping = MappingType.Attribute;
				dataColumn__Book__ISBN.Unique = true;

				#endregion	ISBN
				#region		Title

				DataColumn
				dataColumn__Book__Title = dataTable__Book.Columns.Add("Title", typeof(string));
				dataColumn__Book__Title.AllowDBNull = false;
				dataColumn__Book__Title.MaxLength = 32;
				dataColumn__Book__Title.ColumnMapping = MappingType.Attribute;

				#endregion	Title
				#region		AuthorId

				DataColumn
				dataColumn__Book__AuthorId = dataTable__Book.Columns.Add("AuthorId", typeof(Int32));
				dataColumn__Book__AuthorId.AllowDBNull = false;
				dataColumn__Book__AuthorId.ColumnMapping = MappingType.Attribute;

				#endregion	AuthorId

				dataTable__Book.PrimaryKey = new DataColumn[] { dataColumn__Book__Id };

				#region		Book__Author

				dataSet.Relations.Add
				(
					"Book__Author",
					new DataColumn[]
					{
						dataColumn__Author__Id
					},
					new DataColumn[]
					{
						dataColumn__Book__AuthorId
					}
				);

				#endregion	Book__Author

				#endregion	Book
				#region		Book_Language

				DataTable dataTable__Book_Language = dataSet.Tables.Add("Book_Language");

				#region		BookId

				DataColumn
				dataColumn__Book_Language__BookId = dataTable__Book_Language.Columns.Add("BookId", typeof(Int32));
				dataColumn__Book_Language__BookId.AllowDBNull = false;
				dataColumn__Book_Language__BookId.ColumnMapping = MappingType.Attribute;

				#endregion	BookId
				#region		LanguageCode

				DataColumn
				dataColumn__Book_Language__LanguageCode = dataTable__Book_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Book_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Book_Language__LanguageCode.MaxLength = 3;
				dataColumn__Book_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Title

				DataColumn
				dataColumn__Book_Language__Title = dataTable__Book_Language.Columns.Add("Title", typeof(string));
				dataColumn__Book_Language__Title.AllowDBNull = false;
				dataColumn__Book_Language__Title.MaxLength = 32;
				dataColumn__Book_Language__Title.ColumnMapping = MappingType.Attribute;
				dataColumn__Book_Language__Title.Unique = true;

				#endregion	Title
				#region		AuthorId

				DataColumn
				dataColumn__Book_Language__AuthorId = dataTable__Book_Language.Columns.Add("AuthorId", typeof(Int32));
				dataColumn__Book_Language__AuthorId.AllowDBNull = false;
				dataColumn__Book_Language__AuthorId.ColumnMapping = MappingType.Attribute;

				#endregion	AuthorId

				dataTable__Book_Language.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__Book_Language__BookId, 
						dataColumn__Book_Language__LanguageCode
					};

				#region		Book_Language__Book

				dataSet.Relations.Add
				(
					"Book_Language__Book",
					new DataColumn[]
					{
						dataColumn__Book__Id
					},
					new DataColumn[]
					{
						dataColumn__Book_Language__BookId
					}
				);

				#endregion	Book_Language__Book
				#region		Book_Language__Language

				dataSet.Relations.Add
				(
					"Book_Language__Language",
					new DataColumn[]
					{
						dataColumn__Language__Code
					},
					new DataColumn[]
					{
						dataColumn__Book_Language__LanguageCode
					}
				);

				#endregion	Book_Language__Language
				#region		Book_Language__Author_Language

				dataSet.Relations.Add
				(
					"Book_Language__Author_Language",
					new DataColumn[]
					{
						dataColumn__Author_Language__AuthorId,
						dataColumn__Author_Language__LanguageCode
					},
					new DataColumn[]
					{
						dataColumn__Book_Language__AuthorId,
						dataColumn__Book_Language__LanguageCode
					}
				);

				#endregion	Book_Language__Author_Language

				#endregion	Book

				#region		Sentence

				DataTable dataTable__Sentence = dataSet.Tables.Add("Sentence");

				#region		Id

				DataColumn
				dataColumn__Sentence__Id = dataTable__Sentence.Columns.Add("Id", typeof(Int64));
				dataColumn__Sentence__Id.AllowDBNull = false;
				dataColumn__Sentence__Id.ColumnMapping = MappingType.Attribute;

				#endregion	Id
				#region		String

				DataColumn
				dataColumn__Sentence__String = dataTable__Sentence.Columns.Add("String", typeof(string));
				dataColumn__Sentence__String.AllowDBNull = false;
				dataColumn__Sentence__String.MaxLength = 512;
				dataColumn__Sentence__String.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__Sentence.PrimaryKey = new DataColumn[] { dataColumn__Sentence__Id };

				#endregion	Sentence
				#region		Sentence_Language

				DataTable dataTable__Sentence_Language = dataSet.Tables.Add("Sentence_Language");

				#region		SentenceId

				DataColumn
				dataColumn__Sentence_Language__SentenceId = dataTable__Sentence_Language.Columns.Add("SentenceId", typeof(Int64));
				dataColumn__Sentence_Language__SentenceId.AllowDBNull = false;
				dataColumn__Sentence_Language__SentenceId.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceId
				#region		LanguageCode

				DataColumn
				dataColumn__Sentence_Language__LanguageCode = dataTable__Sentence_Language.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Sentence_Language__LanguageCode.AllowDBNull = false;
				dataColumn__Sentence_Language__LanguageCode.MaxLength = 3;
				dataColumn__Sentence_Language__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		String

				DataColumn
				dataColumn__Sentence_Language__String = dataTable__Sentence_Language.Columns.Add("String", typeof(string));
				dataColumn__Sentence_Language__String.AllowDBNull = false;
				dataColumn__Sentence_Language__String.MaxLength = 512;
				dataColumn__Sentence_Language__String.ColumnMapping = MappingType.Attribute;

				#endregion	String

				dataTable__Sentence_Language.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__Sentence_Language__SentenceId, 
						dataColumn__Sentence_Language__LanguageCode 
					};

				#region		Sentence_Language__Sentence

				dataSet.Relations.Add
				(
					"Sentence_Language__Sentence",
					new DataColumn[]
					{
						dataColumn__Sentence__Id
					},
					new DataColumn[]
					{
						dataColumn__Sentence_Language__SentenceId
					}
				);

				#endregion	Sentence_Language__Sentence
				#region		Sentence_Language__Language

				dataSet.Relations.Add
				(
					"Sentence_Language__Language",
					new DataColumn[]
					{
						dataColumn__Language__Code
					},
					new DataColumn[]
					{
						dataColumn__Sentence_Language__LanguageCode
					}
				);

				#endregion	Sentence_Language__Language


				#endregion	Sentence_Language

				#region		BookSentence

				DataTable dataTable__BookSentence = dataSet.Tables.Add("BookSentence");

				#region		BookId

				DataColumn
				dataColumn__BookSentence__BookId = dataTable__BookSentence.Columns.Add("BookId", typeof(Int32));
				dataColumn__BookSentence__BookId.AllowDBNull = false;
				dataColumn__BookSentence__BookId.ColumnMapping = MappingType.Attribute;

				#endregion	BookId
				#region		Index

				DataColumn
				dataColumn__BookSentence__Index = dataTable__BookSentence.Columns.Add("Index", typeof(Int32));
				dataColumn__BookSentence__Index.AllowDBNull = false;
				dataColumn__BookSentence__Index.ColumnMapping = MappingType.Attribute;

				#endregion	Index
				#region		SentenceId

				DataColumn
				dataColumn__BookSentence__SentenceId = dataTable__BookSentence.Columns.Add("SentenceId", typeof(Int64));
				dataColumn__BookSentence__SentenceId.AllowDBNull = false;
				dataColumn__BookSentence__SentenceId.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceId

				dataTable__BookSentence.PrimaryKey = new DataColumn[] { dataColumn__BookSentence__BookId, dataColumn__BookSentence__Index };

				#region		BookSentence__Book

				dataSet.Relations.Add
				(
					"BookSentence__Book",
					new DataColumn[]
					{
						dataColumn__Book__Id
					},
					new DataColumn[]
					{
						dataColumn__BookSentence__BookId
					}
				);

				#endregion	BookSentence__Book
				#region		BookSentence__Sentence

				dataSet.Relations.Add
				(
					"BookSentence__Sentence",
					new DataColumn[]
					{
						dataColumn__Sentence__Id
					},
					new DataColumn[]
					{
						dataColumn__BookSentence__SentenceId
					}
				);

				#endregion	BookSentence__Sentence

				#endregion	BookSentence

				#region		SentenceWord

				DataTable dataTable__SentenceWord = dataSet.Tables.Add("SentenceWord");

				#region		SentenceId

				DataColumn
				dataColumn__SentenceWord__SentenceId = dataTable__SentenceWord.Columns.Add("SentenceId", typeof(Int64));
				dataColumn__SentenceWord__SentenceId.AllowDBNull = false;
				dataColumn__SentenceWord__SentenceId.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceId
				#region		Index

				DataColumn
				dataColumn__SentenceWord__Index = dataTable__SentenceWord.Columns.Add("Index", typeof(Int16));
				dataColumn__SentenceWord__Index.AllowDBNull = false;
				dataColumn__SentenceWord__Index.ColumnMapping = MappingType.Attribute;

				#endregion	Index
				#region		WordId

				DataColumn
				dataColumn__SentenceWord__WordId = dataTable__SentenceWord.Columns.Add("WordId", typeof(Int32));
				dataColumn__SentenceWord__WordId.AllowDBNull = false;
				dataColumn__SentenceWord__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId

				dataTable__SentenceWord.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__SentenceWord__SentenceId,
						dataColumn__SentenceWord__Index
					};

				#region		SentenceWord__Sentence

				dataSet.Relations.Add
				(
					"SentenceWord__Sentence",
					new DataColumn[]
					{
						dataColumn__Sentence__Id
					},
					new DataColumn[]
					{
						dataColumn__SentenceWord__SentenceId
					}
				);

				#endregion	SentenceWord__Sentence
				#region		SentenceWord__Word

				dataSet.Relations.Add
				(
					"SentenceWord__Word",
					new DataColumn[]
					{
						dataColumn__Word__Id
					},
					new DataColumn[]
					{
						dataColumn__SentenceWord__WordId
					}
				);

				#endregion	SentenceWord__Word

				#endregion	SentenceWord
				
				#region		Sentence_LanguageLanguageWord

				DataTable dataTable__Sentence_LanguageLanguageWord = dataSet.Tables.Add("Sentence_LanguageLanguageWord");

				#region		SentenceId

				DataColumn
				dataColumn__Sentence_LanguageLanguageWord__SentenceId = dataTable__Sentence_LanguageLanguageWord.Columns.Add("SentenceId", typeof(Int64));
				dataColumn__Sentence_LanguageLanguageWord__SentenceId.AllowDBNull = false;
				dataColumn__Sentence_LanguageLanguageWord__SentenceId.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceId
				#region		LanguageCode

				DataColumn
				dataColumn__Sentence_LanguageLanguageWord__LanguageCode = dataTable__Sentence_LanguageLanguageWord.Columns.Add("LanguageCode", typeof(string));
				dataColumn__Sentence_LanguageLanguageWord__LanguageCode.AllowDBNull = false;
				dataColumn__Sentence_LanguageLanguageWord__LanguageCode.MaxLength = 3;
				dataColumn__Sentence_LanguageLanguageWord__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		Index

				DataColumn
				dataColumn__Sentence_LanguageLanguageWord__Index = dataTable__Sentence_LanguageLanguageWord.Columns.Add("Index", typeof(Int16));
				dataColumn__Sentence_LanguageLanguageWord__Index.AllowDBNull = false;
				dataColumn__Sentence_LanguageLanguageWord__Index.ColumnMapping = MappingType.Attribute;

				#endregion	Index
				#region		LanguageWordString

				DataColumn
				dataColumn__Sentence_LanguageLanguageWord__LanguageWordString = dataTable__Sentence_LanguageLanguageWord.Columns.Add("LanguageWordString", typeof(string));
				dataColumn__Sentence_LanguageLanguageWord__LanguageWordString.AllowDBNull = false;
				dataColumn__Sentence_LanguageLanguageWord__LanguageWordString.MaxLength = 32;
				dataColumn__Sentence_LanguageLanguageWord__LanguageWordString.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageWordString

				dataTable__Sentence_LanguageLanguageWord.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__Sentence_LanguageLanguageWord__SentenceId,
						dataColumn__Sentence_LanguageLanguageWord__LanguageCode,
						dataColumn__Sentence_LanguageLanguageWord__Index
					};

				#region		Sentence_LanguageLanguageWord__Sentence_Language

				dataSet.Relations.Add
				(
					"Sentence_LanguageLanguageWord__Sentence_Language",
					new DataColumn[]
					{
						dataColumn__Sentence_Language__SentenceId,
						dataColumn__Sentence_Language__LanguageCode
					},
					new DataColumn[]
					{
						dataColumn__Sentence_LanguageLanguageWord__SentenceId,
						dataColumn__Sentence_LanguageLanguageWord__LanguageCode
					}
				);

				#endregion	Sentence_LanguageLanguageWord__Sentence_Language
				#region		Sentence_LanguageLanguageWord__LanguageWord

				dataSet.Relations.Add
				(
					"Sentence_LanguageLanguageWord__LanguageWord",
					new DataColumn[]
					{
						dataColumn__LanguageWord__LanguageCode,
						dataColumn__LanguageWord__String
					},
					new DataColumn[]
					{
						dataColumn__Sentence_LanguageLanguageWord__LanguageCode,
						dataColumn__Sentence_LanguageLanguageWord__LanguageWordString
					}
				);

				#endregion	Sentence_LanguageLanguageWord__LanguageWord

				#endregion	Sentence_LanguageLanguageWord

				#region		SentenceWord_LanguageWord

				DataTable dataTable__SentenceWord_LanguageWord = dataSet.Tables.Add("SentenceWord_LanguageWord");

				#region		SentenceId

				DataColumn
				dataColumn__SentenceWord_LanguageWord__SentenceId = dataTable__SentenceWord_LanguageWord.Columns.Add("SentenceId", typeof(Int64));
				dataColumn__SentenceWord_LanguageWord__SentenceId.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__SentenceId.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceId
				#region		LanguageCode

				DataColumn
				dataColumn__SentenceWord_LanguageWord__LanguageCode = dataTable__SentenceWord_LanguageWord.Columns.Add("LanguageCode", typeof(string));
				dataColumn__SentenceWord_LanguageWord__LanguageCode.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__LanguageCode.MaxLength = 3;
				dataColumn__SentenceWord_LanguageWord__LanguageCode.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageCode
				#region		SentenceWordIndex

				DataColumn
				dataColumn__SentenceWord_LanguageWord__SentenceWordIndex = dataTable__SentenceWord_LanguageWord.Columns.Add("SentenceWordIndex", typeof(Int16));
				dataColumn__SentenceWord_LanguageWord__SentenceWordIndex.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__SentenceWordIndex.ColumnMapping = MappingType.Attribute;

				#endregion	SentenceWordIndex
				#region		Sentence_LanguageLanguageWordIndex

				DataColumn
				dataColumn__SentenceWord_LanguageWord__Sentence_LanguageLanguageWordIndex = dataTable__SentenceWord_LanguageWord.Columns.Add("Sentence_LanguageLanguageWordIndex", typeof(Int16));
				dataColumn__SentenceWord_LanguageWord__Sentence_LanguageLanguageWordIndex.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__Sentence_LanguageLanguageWordIndex.ColumnMapping = MappingType.Attribute;

				#endregion	Sentence_LanguageLanguageWordIndex
				#region		WordId

				DataColumn
				dataColumn__SentenceWord_LanguageWord__WordId = dataTable__SentenceWord_LanguageWord.Columns.Add("WordId", typeof(Int32));
				dataColumn__SentenceWord_LanguageWord__WordId.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__WordId.ColumnMapping = MappingType.Attribute;

				#endregion	WordId
				#region		LanguageWordString

				DataColumn
				dataColumn__SentenceWord_LanguageWord__LanguageWordString = dataTable__SentenceWord_LanguageWord.Columns.Add("LanguageWordString", typeof(string));
				dataColumn__SentenceWord_LanguageWord__LanguageWordString.AllowDBNull = false;
				dataColumn__SentenceWord_LanguageWord__LanguageWordString.MaxLength = 32;
				dataColumn__SentenceWord_LanguageWord__LanguageWordString.ColumnMapping = MappingType.Attribute;

				#endregion	LanguageWordString

				dataTable__SentenceWord_LanguageWord.PrimaryKey 
					= new DataColumn[] 
					{ 
						dataColumn__SentenceWord_LanguageWord__SentenceId,
						dataColumn__SentenceWord_LanguageWord__LanguageCode,
						dataColumn__SentenceWord_LanguageWord__SentenceWordIndex,
						dataColumn__SentenceWord_LanguageWord__Sentence_LanguageLanguageWordIndex
					};

				#region		SentenceWord_LanguageWord__LanguageWord

				dataSet.Relations.Add
				(
					"SentenceWord_LanguageWord__LanguageWord",
					new DataColumn[]
					{
						dataColumn__SentenceWord__SentenceId,
						dataColumn__SentenceWord__Index,
						dataColumn__SentenceWord__WordId		/// +
					},
					new DataColumn[]
					{
						dataColumn__SentenceWord_LanguageWord__SentenceId,
						dataColumn__SentenceWord_LanguageWord__SentenceWordIndex,
						dataColumn__SentenceWord_LanguageWord__WordId	/// +
					}
				);

				#endregion	SentenceWord_LanguageWord__LanguageWord
				#region		SentenceWord_LanguageWord__Sentence_LanguageLanguageWord

				dataSet.Relations.Add
				(
					"SentenceWord_LanguageWord__Sentence_Language",
					new DataColumn[]
					{
						dataColumn__Sentence_LanguageLanguageWord__SentenceId,
						dataColumn__Sentence_LanguageLanguageWord__LanguageCode,
						dataColumn__Sentence_LanguageLanguageWord__Index,
						dataColumn__Sentence_LanguageLanguageWord__LanguageWordString
					},
					new DataColumn[]
					{
						dataColumn__SentenceWord_LanguageWord__SentenceId,
						dataColumn__SentenceWord_LanguageWord__LanguageCode,
						dataColumn__SentenceWord_LanguageWord__Sentence_LanguageLanguageWordIndex,
						dataColumn__SentenceWord_LanguageWord__LanguageWordString
					}
				);

				#endregion	SentenceWord_LanguageWord__Sentence_LanguageLanguageWord
				#region		SentenceWord_LanguageWord__Word_LanguageWord

				dataSet.Relations.Add
				(
					"SentenceWord_LanguageWord__Word_LanguageWord",
					new DataColumn[]
					{
						dataColumn__Word_LanguageWord__WordId,
						dataColumn__Word_LanguageWord__LanguageCode,
						dataColumn__Word_LanguageWord__LanguageWordString
					},
					new DataColumn[]
					{
						dataColumn__SentenceWord_LanguageWord__WordId,
						dataColumn__SentenceWord_LanguageWord__LanguageCode,
						dataColumn__SentenceWord_LanguageWord__LanguageWordString
					}
				);

				#endregion	SentenceWord_LanguageWord__Word_LanguageWord

				#endregion	SentenceWord_LanguageWord

				#endregion	[structure]
				#region		[saving xsd]

				dataSet.WriteXmlSchema("..\\..\\BabebiDataSet.xsd");

				#endregion	[saving xsd}

				Console.WriteLine("Done create/save DataSet.");
			}


			#region		load the dataSet with the xml file content.

			if (! doStructure)
			{
				System.IO.DirectoryInfo directoryInfo = new System.IO.DirectoryInfo("..\\..\\Xmls");

				if (!directoryInfo.Exists)
				{
					throw new ApplicationException("Unable to find the 'Xmls' directory associated to the path: '" + directoryInfo.FullName + "'.");
				}

				string currentXmlFilesDirectoryFullName = directoryInfo.FullName;

				System.IO.FileInfo[] fileInfos = directoryInfo.GetFiles("BabebiDataSet*.xml");

				if (fileInfos.Length == 0)
				{
					throw new ApplicationException("The 'Xmls' directory (" + directoryInfo.FullName + ") does not contain any file.");
				}

				List<string> fileNames = new List<string>();
				foreach (System.IO.FileInfo fileInfo in fileInfos)
				{
					fileNames.Add(fileInfo.FullName);
				}
				fileNames.Sort();

				string lastXmlFileFullName = fileNames.Last();

				BabebiDataSet dataSetLoaded = new BabebiDataSet()
				{
					Namespace = "Babebi4",
					CaseSensitive = true
				};

				dataSetLoaded.ReadXml(lastXmlFileFullName);
				dataSetLoaded.AcceptChanges();

				Console.WriteLine("Done load Dataset from XML.");

				#region		debug zone

//				BabebiDataSet.PatternRow patternRow = dataSetLoaded.Pattern.FindById(0);
//				BabebiDataSet.FromPatternRow fromPatternRow = dataSetLoaded.FromPattern.AddFromPatternRow("P", 1, patternRow, 0);

				#endregion	debug zone
			}

			#endregion	load the dataSet with the xml file content.


			Console.ReadLine();
		}
	}
}

#region		performance test
/*
DateTime dateTime1 = DateTime.Now;

for (int i = 0; i < 1000000; i++)
{
	BabebiDataSet.PatternRow p = dataSetLoading.Pattern.FindById(1);
}

DateTime dateTime2 = DateTime.Now;

TimeSpan tsFind = dateTime2 - dateTime1;
Console.WriteLine(tsFind.ToString());

BabebiDataSet.WordOrPatternRow wop = dataSetLoading.WordOrPattern.FindBySubscriberCodeSubscriberId("P", 1);

DateTime dateTime3 = DateTime.Now;

for (int i = 0; i < 1000000; i++)
{
	BabebiDataSet.PatternRow p = wop.GetPatternRows().First();
}

DateTime dateTime4 = DateTime.Now;

TimeSpan ts11C = dateTime4 - dateTime3;
Console.WriteLine(ts11C.ToString());
Console.ReadLine();

*/
#endregion	performance test			

#region		// WordOrPatternParenthood  (Link)
/*
		DataTable dataTable__WordOrPatternParenthood = dataSet.Tables.Add("WordOrPatternParenthood");

		#region		ParentWordOrPatternSubscriberCode

		DataColumn
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode = dataTable__WordOrPatternParenthood.Columns.Add("ParentWordOrPatternSubscriberCode");
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode.DataType = typeof(string);
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode.AllowDBNull = false;
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode.MaxLength = 32;
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode.ColumnMapping = MappingType.Attribute;

		#endregion	ParentWordOrPatternSubscriberCode
		#region		ParentWordOrPatternSubscriberId

		DataColumn
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId = dataTable__WordOrPatternParenthood.Columns.Add("ParentWordOrPatternSubscriberId", typeof(Int32));
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId.AllowDBNull = false;
		dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId.ColumnMapping = MappingType.Attribute;

		#endregion	ParentWordOrPatternSubscriberId
		#region		ChildWordOrPatternSubscriberCode

		DataColumn
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode = dataTable__WordOrPatternParenthood.Columns.Add("ChildWordOrPatternSubscriberCode");
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode.DataType = typeof(string);
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode.AllowDBNull = false;
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode.MaxLength = 32;
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode.ColumnMapping = MappingType.Attribute;

		#endregion	ChildWordOrPatternSubscriberCode
		#region		ChildWordOrPatternSubscriberId

		DataColumn
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberId = dataTable__WordOrPatternParenthood.Columns.Add("ChildWordOrPatternSubscriberId", typeof(Int32));
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberId.AllowDBNull = false;
		dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberId.ColumnMapping = MappingType.Attribute;

		#endregion	ChildWordOrPatternSubscriberId
		#region		Rank

		DataColumn dataColumn__WordOrPatternParenthood__Rank = dataTable__WordOrPatternParenthood.Columns.Add("Rank", typeof(short));
		dataColumn__WordOrPatternParenthood__Rank.AllowDBNull = false;
		dataColumn__WordOrPatternParenthood__Rank.DefaultValue = 1;
		dataColumn__WordOrPatternParenthood__Rank.ColumnMapping = MappingType.Attribute;

		#endregion	Rank

		dataTable__WordOrPatternParenthood.PrimaryKey
			= new DataColumn[]
			{
			dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode,
			dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId,
			dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode,
			dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberId
			};

		#region		WordOrPatternParenthood__WordOrPattern__Parent

		dataSet.Relations.Add
		(
			"WordOrPatternParenthood__WordOrPattern__Parent",
			new DataColumn[]
			{
			dataColumn__WordOrPattern__SubscriberCode,
			dataColumn__WordOrPattern__SubscriberId
			},
			new DataColumn[]
			{
			dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode,
			dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId
			}
		);

		#endregion	WordOrPatternParenthood__WordOrPattern__Parent
		#region		WordOrPatternParenthood__WordOrPattern__Child

		dataSet.Relations.Add
		(
			"WordOrPattern__WordOrPatternParenthood__Child",
			new DataColumn[]
			{
			dataColumn__WordOrPattern__SubscriberCode,
			dataColumn__WordOrPattern__SubscriberId
			},
			new DataColumn[]
			{
			dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberCode,
			dataColumn__WordOrPatternParenthood__ChildWordOrPatternSubscriberId
			}
		);

		#endregion	WordOrPatternParenthood__WordOrPattern__Child

		dataTable__WordOrPatternParenthood.Constraints
			.Add
			(
				"UC__WordOrPatternParenthood__WordOrPatternSubscriberCode__WordOrPatternSubscriberId__Rank", 
				new DataColumn[] 
				{
				dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberCode,
				dataColumn__WordOrPatternParenthood__ParentWordOrPatternSubscriberId,
				dataColumn__WordOrPatternParenthood__Rank
				}, 
				false
			);
		*/
#endregion	// WordOrPatternParenthood  (Link)


